import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { MainComponent } from './main/main.component';
import { VideoComponent } from './video/video.component';
import { BaiduMapModule } from 'angular2-baidu-map';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { ModalComponent } from './modal/modal.component';
import { ApiModule } from './api';
import { HttpClientModule } from '@angular/common/http';
import { ColorPickerModule } from 'ngx-color-picker';
import { NgZorroAntdModule, NZ_I18N, zh_CN,NzIconModule } from 'ng-zorro-antd';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { LoginComponent } from './login/login.component';

@NgModule({
  declarations: [
    AppComponent,
    MainComponent,
    VideoComponent,
    ModalComponent,
    LoginComponent
  ],
  imports: [
   
    
    HttpClientModule,
    BrowserModule,
    AppRoutingModule,
    ColorPickerModule,
    BrowserAnimationsModule,
    FormsModule,
    ReactiveFormsModule,
    ApiModule,
    NzIconModule,
       /** 导入 ng-zorro-antd 模块 **/
       NgZorroAntdModule,
    BaiduMapModule.forRoot({ ak: 'KhQqnL3owyAzqjr4zCGbWiiHwPFmKTD6' })
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule { }
