/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.wzcode.entity;


import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 物资编码模块Entity
 * @author 胡懿
 * @version 2023-02-24
 */
public class Wzcode extends DataEntity<Wzcode> {
	
	private static final long serialVersionUID = 1L;
	private String code;		// 类型编码
	private String num;		// 最后一个编码号
	
	public Wzcode() {
		super();
	}

	public Wzcode(String id){
		super(id);
	}

	@ExcelField(title="类型编码", align=2, sort=1)
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@ExcelField(title="最后一个编码号", align=2, sort=2)
	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}

	public void setIntNum(int n) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < (4 - (n + "").length()); i ++) {
			sb.append("0");
		}
		this.num = sb.toString() + n;
	}

	public int getIntNum() {
		if (StringUtils.isNotBlank(this.num)) {
			return Integer.parseInt(this.num);
		} else {
			return 0;
		}
	}

	public String getCodeAndNum() {
		SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM");
		return this.code + "-" +  sdf.format(new Date()) + "-" + this.getNum();
	}
}