package com.jeeplus.modules.warehouse.ledger.Utils;

import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelStyleUtils {

    /**
     * 第一行样式
     * @return
     */
    public static CellStyle topOneCellStyle(XSSFWorkbook workbook) {
        // 样式设置
        CellStyle style = workbook.createCellStyle();
        // 水平对齐方式
        style.setAlignment(HorizontalAlignment.CENTER);
        // 垂直居中
        style.setVerticalAlignment(VerticalAlignment.CENTER);

        style.setBorderTop(BorderStyle.THIN);
        //设置右边框线条类型
        style.setBorderRight(BorderStyle.THIN);
        //设置下边框线条类型
        style.setBorderBottom(BorderStyle.THIN);
        //设置左边框线条类型
        style.setBorderLeft(BorderStyle.THIN);
        //设置上边框线条颜色
        style.setTopBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置右边框线条颜色
        style.setRightBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置下边框线条颜色
        style.setBottomBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置左边框线条颜色
        style.setLeftBorderColor(IndexedColors.BLUE_GREY.getIndex());

        Font font = workbook.createFont();
        font.setFontHeight((short) 500);
        font.setBold(true);
        font.setUnderline(Font.U_SINGLE); // 下划线
        font.setFontName("宋体");
        font.setColor(IndexedColors.BLUE_GREY.getIndex());
        style.setFont(font);
        return style;
    }

    public static CellStyle topTwoCellStyle(XSSFWorkbook workbook) {
        // 样式设置
        CellStyle style = workbook.createCellStyle();
        // 水平对齐方式
        style.setAlignment(HorizontalAlignment.LEFT);
        // 垂直居中
        style.setVerticalAlignment(VerticalAlignment.CENTER);

        style.setBorderTop(BorderStyle.THIN);
        //设置右边框线条类型
        style.setBorderRight(BorderStyle.THIN);
        //设置下边框线条类型
        style.setBorderBottom(BorderStyle.THIN);
        //设置左边框线条类型
        style.setBorderLeft(BorderStyle.THIN);
        //设置上边框线条颜色
        style.setTopBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置右边框线条颜色
        style.setRightBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置下边框线条颜色
        style.setBottomBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置左边框线条颜色
        style.setLeftBorderColor(IndexedColors.BLUE_GREY.getIndex());


        Font font = workbook.createFont();
        font.setFontHeight((short) 220);
        font.setFontName("宋体");
        font.setColor(IndexedColors.BLUE_GREY.getIndex());
        style.setFont(font);
        return style;
    }

    public static CellStyle topThreeCellStyle(XSSFWorkbook workbook) {
        // 样式设置
        CellStyle style = workbook.createCellStyle();
        // 水平对齐方式
        style.setAlignment(HorizontalAlignment.CENTER);
        // 垂直居中
        style.setVerticalAlignment(VerticalAlignment.CENTER);

        style.setBorderTop(BorderStyle.THIN);
        //设置右边框线条类型
        style.setBorderRight(BorderStyle.THIN);
        //设置下边框线条类型
        style.setBorderBottom(BorderStyle.THIN);
        //设置左边框线条类型
        style.setBorderLeft(BorderStyle.THIN);
        //设置上边框线条颜色
        style.setTopBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置右边框线条颜色
        style.setRightBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置下边框线条颜色
        style.setBottomBorderColor(IndexedColors.BLUE_GREY.getIndex());
        //设置左边框线条颜色
        style.setLeftBorderColor(IndexedColors.BLUE_GREY.getIndex());

        Font font = workbook.createFont();
        font.setFontHeight((short) 220);
        font.setFontName("宋体");
        font.setColor(IndexedColors.BLUE_GREY.getIndex());
        style.setFont(font);
        return style;
    }
}
