<%--
  Created by IntelliJ IDEA.
  User: yangzi
  Date: 2023/2/21
  Time: 10:29
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<%@include file="/webpage/include/logic.jsp"  %>
<table id="detail_table"></table>
<script>
    var selector = "#detail_table";
    var LODOP;
    function initTable() {
        var data = [];
        $(selector).bootstrapTable({
            data: data,
            columns: [
                {
                    field: 'no',
                    title: '序号',
                    align: 'center',
                    width: 60,
                    formatter: function (value, row, index) {
                        return '<span>' + (index + 1) + '</span>'
                    }
                },
                {
                    field: 'type.name',
                    title: '品名',
                    sortable: true,
                    sortName: 'type.name',
                },
                {
                    field: 'type.code',
                    title: '代码',
                    sortable: true,
                    sortName: 'type.code'
                },
                {
                    field: 'code',
                    title: '物资编码'
                },
                {
                    field: 'batchNum',
                    title: '批次号',
                },
                {
                    field: 'amount',
                    title: '单价'
                },
                {
                    field: "type.unit",
                    title: '单位'
                },
                {
                    field: 'model',
                    title: '型号',
                    sortable: true,
                    sortName: 'model'
                },
                {
                    field: 'num',
                    title: '数量'
                },
                {
                    field: 'sum',
                    title: '总价',
                    sortName: 'sum',
                    formatter (v, row) {
                        return new Big(row.num).times(row.amount).toNumber()
                    }
                },
                {
                    title: '操作',
                    align: 'center',
                    formatter () {
                        return '<a class="view-qrcode">查看</a>&nbsp;&nbsp;<a class="print">打印</a>'
                    },
                    events: {
                        'click .view-qrcode': function (e,value,row){
                            jp.showPic('${ctxPath}'+row.qr.url)
                        },
                        'click .print': function (e,value,row){
                            onPrint(row);
                        }
                    }
                },
                <%--{--%>
                <%--    title: '操作',--%>
                <%--    align: 'center',--%>
                <%--    formatter: function (){--%>
                <%--        return '<a class="view-detail">查看明细</a>'--%>
                <%--    },--%>
                <%--    events: {--%>
                <%--       'click .view-detail': function (e,value,row){--%>
                <%--            layer.open({--%>
                <%--                title: '查看明细',--%>
                <%--                type: 1,--%>
                <%--                auto: true,--%>
                <%--                area: ['1000', '600'],--%>
                <%--                content: $("#detailTpl").html(),--%>
                <%--                success: function (){--%>
                <%--                    $("#table").bootstrapTable({--%>
                <%--                        method: 'get',--%>
                <%--                        url: '${ctx}/warehouse/ledger/ledger/infoDate?batchNum='+ row.batchNum+'&ledger.id=${ledger.id}',--%>
                <%--                        //是否显示分页（*）--%>
                <%--                        pagination: true,--%>
                <%--                        //排序方式--%>
                <%--                        sortOrder: "asc",--%>
                <%--                        //初始化加载第一页，默认第一页--%>
                <%--                        pageNumber:1,--%>
                <%--                        //每页的记录行数（*）--%>
                <%--                        pageSize: 10,--%>
                <%--                        //可供选择的每页的行数（*）--%>
                <%--                        pageList: [10, 25, 50, 100],--%>
                <%--                        sidePagination: "server",--%>
                <%--                        queryParams : function(params) {--%>
                <%--                            var searchParam = $("#searchForm").serializeJSON();--%>
                <%--                            searchParam.pageNo = params.limit === undefined? "1" :params.offset/params.limit+1;--%>
                <%--                            searchParam.pageSize = params.limit === undefined? -1 : params.limit;--%>
                <%--                            searchParam.orderBy = params.sort === undefined? "" : params.sort+ " "+  params.order;--%>
                <%--                            return searchParam;--%>
                <%--                        },--%>
                <%--                        columns: [--%>
                <%--                            {checkbox:true},--%>
                <%--                            {field: 'code', title: '物资编码'},--%>
                <%--                            {--%>
                <%--                                field: 'type.name',--%>
                <%--                                title: '品名',--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: 'type.code',--%>
                <%--                                title: '代码',--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: 'batchNum',--%>
                <%--                                title: '批次号',--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: 'amount',--%>
                <%--                                title: '单价'--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: "type.unit",--%>
                <%--                                title: '单位'--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: 'amount',--%>
                <%--                                title: '单价'--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: "type.unit",--%>
                <%--                                title: '单位'--%>
                <%--                            },--%>
                <%--                            {field: 'model', title: '型号'},--%>
                <%--                            {field: 'shelves.name', title: '货架'},--%>
                <%--                            // {field: 'amount', title: '单价'},--%>
                <%--                            {--%>
                <%--                                field: 'num',--%>
                <%--                                title: '数量'--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: 'sum',--%>
                <%--                                title: '总价',--%>
                <%--                                sortName: 'sum',--%>
                <%--                                formatter (v, row) {--%>
                <%--                                    return new Big(row.num).times(row.amount).toNumber()--%>
                <%--                                }--%>
                <%--                            },--%>
                <%--                            {--%>
                <%--                                field: 'qr.url',--%>
                <%--                                title: '二维码',--%>
                <%--                                sortable: true,--%>
                <%--                                sortName: 'qr.url',--%>
                <%--                                formatter: function (){--%>
                <%--                                    return '<a class="view-qrcode">查看</a>&nbsp;&nbsp;<a class="print">打印</a>';--%>
                <%--                                },--%>
                <%--                                events: {--%>
                <%--                                    'click .view-qrcode': function (e,value,row){--%>
                <%--                                        jp.showPic('${ctxPath}'+row.qr.url)--%>
                <%--                                    },--%>
                <%--                                    'click .print': function (e,value,row){--%>
                <%--                                        onPrint(row);--%>
                <%--                                    }--%>
                <%--                                }--%>
                <%--                            }--%>
                <%--                        ]--%>
                <%--                    });--%>

                <%--                    $('#table').on('check.bs.table uncheck.bs.table load-success.bs.table ' +--%>
                <%--                        'check-all.bs.table uncheck-all.bs.table', function () {--%>
                <%--                        $('#batchPrintBtn').prop('disabled', ! $('#table').bootstrapTable('getSelections').length);--%>
                <%--                    });--%>

                <%--                },--%>
                <%--            })--%>
                <%--        }--%>
                <%--    }--%>
                <%--}--%>
            ].map(function (e) {
                e.align = 'center';
                return e;
            })
        });

        jp.get("${ctx}/warehouse/ledger/ledger/detail?id=${ledger.id}", function (ledger) {
            var data = ledger.ledgerInfoList || [];
            $(selector).bootstrapTable('append', data);
        })
    }

    function getSelections() {
        return $(selector).bootstrapTable('getSelections');
    }

    function removeRow(index, rowId, rowDelFlag) {
        if (rowId) {
            var delFlag = rowDelFlag == 1 ? 0 : 1
            updateRow(index, {
                delFlag: delFlag
            })
        } else {
            $(selector).bootstrapTable("remove", {
                field: '$index',
                values: [index]
            })
        }
    }

    function updateRow(index, row) {
        $(selector).bootstrapTable('updateRow', {
            index: index,
            row: row
        })
    }

    function onInputChange(rowIndex, elem, field) {
        var obj = {};
        obj[field] = $(elem).val()
        var timer = null;
        clearTimeout(timer);
        timer = setTimeout(function () {
            updateRow(rowIndex, obj)
        }, 0)
    }

    function onSelectType(nodes, rowIndex) {
        if (Array.isArray(nodes) && nodes.length === 1) {
            var node = nodes[0];
            var obj = {
                type: {
                    id: node.id,
                    name: node.text
                }
            };
            updateRow(rowIndex, obj)
        }
    }

    /**
     * 获取所有明细数据
     * @returns {*|jQuery}
     */
    function getTableData() {
        return $(selector).bootstrapTable('getData');
    }

    function initLodop(){
        LODOP = getLodop(document.getElementById('LODOP_OB'),document.getElementById('LODOP_EM'));
    }

    function onPrint_(row) {
        if(!LODOP){
            initLodop();
        }
        LODOP.PRINT_INIT("打印货品");
        LODOP.SET_PRINT_PAGESIZE(1,400,600,0);
        if(!row){
           var selections = $("#table").bootstrapTable('getSelections');
            selections.forEach(function(item){
                LODOP.NewPage();
                var imgUrl = "${ctxPath}/" + item.qr.url;
                LODOP.ADD_PRINT_IMAGE('0%',"0%","100%","100%","<img width='150'  border='0' src='"+imgUrl+"' />");
            });
            LODOP.PREVIEW();
           return;
        }

        LODOP.NewPage();
        var imgUrl = "${ctxPath}/" + row.qr.url;
        LODOP.ADD_PRINT_IMAGE('0%',"0%","100%","100%","<img width='150'  border='0' src='"+imgUrl+"' />");
        LODOP.PREVIEW();
    }

    function onPrint (row) {
        <%--if(!row){--%>
        <%--    var selections = $("#detail_table").bootstrapTable('getSelections');--%>
        <%--    selections.forEach(function(item){--%>
        <%--        // LODOP.NewPage();--%>
        <%--        var imgUrl = "${ctxPath}/" + item.qr.url;--%>
        <%--        // LODOP.ADD_PRINT_IMAGE('0%',"0%","100%","100%","<img width='150'  border='0' src='"+imgUrl+"' />");--%>
        <%--    });--%>
        <%--    // LODOP.PREVIEW();--%>
        <%--    return;--%>
        <%--}--%>
        var imgUrl = "${ctxPath}/" + row.qr.url;
        _thermal_Image_print_(imgUrl);
    }
</script>

<script id="detailTpl" type="text/html">
    <br>
    <div class="container-fluid">
        <button id="batchPrintBtn" class="btn btn-primary" onclick="onPrint()" disabled>批量打印</button>
        <table id="table"></table>
    </div>
</script>
