/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.profitwarehousing.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import com.google.common.collect.Lists;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.sys.entity.User;

/**
 * 盘盈入库单Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class ProfitWarehousing extends DataEntity<ProfitWarehousing> {
	
	private static final long serialVersionUID = 1L;
	private String number;		// 盘盈入库单号
	private User operator;		// 操作人
	private Date time;		// 时间
	private Date beginTime;		// 开始 时间
	private Date endTime;		// 结束 时间
	private BigDecimal sum; // 总价
	private List<ProfitWarehousingInfo> profitWarehousingInfoList = Lists.newArrayList();		// 子表列表
	
	public ProfitWarehousing() {
		super();
	}

	public ProfitWarehousing(String id){
		super(id);
	}

	@ExcelField(title="盘盈入库单号", align=2, sort=1)
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@ExcelField(title="操作人", align=2, sort=2)
	public User getOperator() {
		return operator;
	}

	public void setOperator(User operator) {
		this.operator = operator;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ExcelField(title="时间", align=2, sort=3)
	public Date getTime() {
		return time;
	}
	@ExcelField(title="总价", align=2, sort=4)
	public BigDecimal getSum() {
		return sum;
	}

	public void setSum(BigDecimal sum) {
		this.sum = sum;
	}

	public void setTime(Date time) {
		this.time = time;
	}
	
	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}
	
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
		
	public List<ProfitWarehousingInfo> getProfitWarehousingInfoList() {
		return profitWarehousingInfoList;
	}

	public void setProfitWarehousingInfoList(List<ProfitWarehousingInfo> profitWarehousingInfoList) {
		this.profitWarehousingInfoList = profitWarehousingInfoList;
	}
}