/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialtype.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import javax.validation.constraints.NotNull;

import com.jeeplus.core.persistence.TreeEntity;

import java.math.BigDecimal;

/**
 * 物资类型Entity
 * @author zhnaglt
 * @version 2023-02-13
 */
public class MaterialType extends TreeEntity<MaterialType> {
	
	private static final long serialVersionUID = 1L;
	private String code;		// 物资类型编码
	private BigDecimal amount; // 单价
	private String unit; // 单位
	private int last;
	
	
	public MaterialType() {
		super();
	}

	public MaterialType(String id){
		super(id);
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	public  MaterialType getParent() {
			return parent;
	}
	
	@Override
	public void setParent(MaterialType parent) {
		this.parent = parent;
		
	}
	
	public String getParentId() {
		return parent != null && parent.getId() != null ? parent.getId() : "0";
	}

	public int getLast() {
		return last;
	}

	public void setLast(int last) {
		this.last = last;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}
}