/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.storage.entity;

import com.jeeplus.modules.warehouse.goods.entity.GoodsInfo;
import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 入库明细Entity
 * @author huyi
 * @version 2023-02-13
 */
public class StorageInfo extends DataEntity<StorageInfo> {
	
	private static final long serialVersionUID = 1L;
	private Storage storage;		// 主表id 父类
	private String name;		// 名称
	private MaterialType type;		// 类型
	private String model;		// 型号
	private GoodsInfo goodsInfo;		// 货品明细id
	private String shelvesIds; // 货架id集合
	private String warehouseIds; // 仓库id集合
	private BigDecimal amount; // 单价
	private int num; // 数量
	private BigDecimal infoSum; // 总价

	private List<Shelves> shelvesList;		// 货架id
	private List<Warehouse> warehouseList; // 仓库外键

	private QrCode qrCode; // 前端保存入库单时使用的临时二维码对象

	/**
	 * 查询使用的属性-------
	 */
	private Date beginTime;
	private Date endTime;

	/**
	 * ------------
	 */

	public StorageInfo() {
		super();
	}

	public StorageInfo(String id){
		super(id);
	}

	public StorageInfo(Storage storage){
		this.storage = storage;
	}

	public Storage getStorage() {
		return storage;
	}

	public void setStorage(Storage storage) {
		this.storage = storage;
	}
	
	@ExcelField(title="名称", align=2, sort=2)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@ExcelField(title="类型", fieldType=MaterialType.class, value="type.name", align=2, sort=3)
	public MaterialType getType() {
		return type;
	}

	public void setType(MaterialType type) {
		this.type = type;
	}
	
	@ExcelField(title="型号", align=2, sort=4)
	public String getModel() {
		return model;
	}

	public void setModel(String model) {
		this.model = model;
	}

	@ExcelField(title="货品明细id", align=2, sort=5)
	public GoodsInfo getGoodsInfo() {
		return goodsInfo;
	}

	public void setGoodsInfo(GoodsInfo goodsInfo) {
		this.goodsInfo = goodsInfo;
	}


	public QrCode getQrCode() {
		return qrCode;
	}

	public void setQrCode(QrCode qrCode) {
		this.qrCode = qrCode;
	}


	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public int getNum() {
		return num;
	}

	public void setNum(int num) {
		this.num = num;
	}

	public String getShelvesIds() {
		return shelvesIds;
	}

	public void setShelvesIds(String shelvesIds) {
		this.shelvesIds = shelvesIds;
	}

	public String getWarehouseIds() {
		return warehouseIds;
	}

	public void setWarehouseIds(String warehouseIds) {
		this.warehouseIds = warehouseIds;
	}

	public List<Shelves> getShelvesList() {
		return shelvesList;
	}

	public void setShelvesList(List<Shelves> shelvesList) {
		this.shelvesList = shelvesList;
	}

	public List<Warehouse> getWarehouseList() {
		return warehouseList;
	}

	public void setWarehouseList(List<Warehouse> warehouseList) {
		this.warehouseList = warehouseList;
	}

	public BigDecimal getInfoSum() {
		return infoSum;
	}

	public void setInfoSum(BigDecimal infoSum) {
		this.infoSum = infoSum;
	}

	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
}