package com.jeeplus.modules.warehouse.ledger.Utils;

import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelStyleUtils {

    /**
     * 第一行样式
     * @return
     */
    public static CellStyle topOneCellStyle(XSSFWorkbook workbook) {
        // 样式设置
        CellStyle topStyle = workbook.createCellStyle();
        // 水平对齐方式
        topStyle.setAlignment(HorizontalAlignment.CENTER);
        // 垂直居中
        topStyle.setVerticalAlignment(VerticalAlignment.CENTER);

        Font topFont = workbook.createFont();
        topFont.setFontHeight((short) 500);
        topFont.setBold(true);
        topFont.setUnderline(Font.U_SINGLE); // 下划线
        topFont.setFontName("宋体");
        topFont.setColor(IndexedColors.BLUE_GREY.getIndex());
        topStyle.setFont(topFont);
        return topStyle;
    }

    public static CellStyle topTwoCellStyle(XSSFWorkbook workbook) {
        // 样式设置
        CellStyle topStyle = workbook.createCellStyle();
        // 水平对齐方式
        topStyle.setAlignment(HorizontalAlignment.LEFT);
        // 垂直居中
        topStyle.setVerticalAlignment(VerticalAlignment.CENTER);

        Font topFont = workbook.createFont();
        topFont.setFontHeight((short) 220);
        topFont.setFontName("宋体");
        topFont.setColor(IndexedColors.BLUE_GREY.getIndex());
        topStyle.setFont(topFont);
        return topStyle;
    }
}
