/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.qrcode.entity;


import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.goods.entity.GoodsInfo;
import com.jeeplus.modules.warehouse.profitwarehousing.entity.ProfitWarehousingInfo;

import java.util.List;

/**
 * 二维码Entity
 * @author 胡懿
 * @version 2023-02-13
 */
public class QrCode extends DataEntity<QrCode> {
	
	private static final long serialVersionUID = 1L;
	private GoodsInfo goodsInfo;		// 货品明细外键
	private String code;		// 物资编码
	private String url;		// 二维码存储路径
	private String state; // 物资状态码 (0：未入库，1：已入库未入账，2：已入账未下账，3：下账)
	private ProfitWarehousingInfo profitWarehousingInfo;		// 盘盈入库明细外键
	private String comeFlag;		// 二维码生成来源，（0 货品 ， 1 盘盈入库）

	public ProfitWarehousingInfo getProfitWarehousingInfo() {
		return profitWarehousingInfo;
	}

	public void setProfitWarehousingInfo(ProfitWarehousingInfo profitWarehousingInfo) {
		this.profitWarehousingInfo = profitWarehousingInfo;
	}

	public String getComeFlag() {
		return comeFlag;
	}

	public void setComeFlag(String comeFlag) {
		this.comeFlag = comeFlag;
	}

	public QrCode() {
		super();
	}

	public QrCode(String id){
		super(id);
	}

	@ExcelField(title="货品明细外键", align=2, sort=1)
	public GoodsInfo getGoodsInfo() {
		return goodsInfo;
	}

	public void setGoodsInfo(GoodsInfo goodsInfo) {
		this.goodsInfo = goodsInfo;
	}

	@ExcelField(title="物资编码", align=2, sort=2)
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@ExcelField(title="二维码存储路径", align=2, sort=3)
	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

}