/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.outbound.entity;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import com.google.common.collect.Lists;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.sys.entity.User;

/**
 * 出库信息Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class Outbound extends DataEntity<Outbound> {
	
	private static final long serialVersionUID = 1L;
	private String number;		// 出库单号
	private String relationId;		// 相关表单ID
	private Date outboundTime;		// 出库时间
	private String type;		// 出库分类
	private User operator;		// 操作人
	private Date beginOutboundTime;		// 开始 出库时间
	private Date endOutboundTime;		// 结束 出库时间
	private List<OutboundInfo> outboundInfoList = Lists.newArrayList();		// 子表列表
	
	public Outbound() {
		super();
	}

	public Outbound(String id){
		super(id);
	}

	@ExcelField(title="出库单号", align=2, sort=1)
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@ExcelField(title="相关表单ID", align=2, sort=2)
	public String getRelationId() {
		return relationId;
	}

	public void setRelationId(String relationId) {
		this.relationId = relationId;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ExcelField(title="出库时间", align=2, sort=3)
	public Date getOutboundTime() {
		return outboundTime;
	}

	public void setOutboundTime(Date outboundTime) {
		this.outboundTime = outboundTime;
	}
	
	@ExcelField(title="出库分类", dictType="", align=2, sort=4)
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	@ExcelField(title="操作人", align=2, sort=5)
	public User getOperator() {
		return operator;
	}

	public void setOperator(User operator) {
		this.operator = operator;
	}
	
	public Date getBeginOutboundTime() {
		return beginOutboundTime;
	}

	public void setBeginOutboundTime(Date beginOutboundTime) {
		this.beginOutboundTime = beginOutboundTime;
	}
	
	public Date getEndOutboundTime() {
		return endOutboundTime;
	}

	public void setEndOutboundTime(Date endOutboundTime) {
		this.endOutboundTime = endOutboundTime;
	}
		
	public List<OutboundInfo> getOutboundInfoList() {
		return outboundInfoList;
	}

	public void setOutboundInfoList(List<OutboundInfo> outboundInfoList) {
		this.outboundInfoList = outboundInfoList;
	}
}