<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>货架信息管理</title>
    <meta name="decorator" content="ani"/>
    <link rel="stylesheet" href="${ctxStatic}/common/css/form.css">
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-body">
                    <form:form id="inputForm" modelAttribute="shelves" action="${ctx}/warehouse/shelves/shelves/save"
                               method="post" class="form-horizontal">
                        <form:hidden path="id"/>
                        <h3 class="text-center">货架表</h3>
                        <table class="table table-bordered main-table">
                            <tr>
                                <td><font color="red">*</font>货架名称</td>
                                <td>
                                    <form:input path="name" htmlEscape="false" class="form-control required"/>
                                </td>
                                <td><font color="red">*</font>货架编号</td>
                                <td>
                                    <form:input path="number" htmlEscape="false" class="form-control required"/>
                                </td>
                            </tr>
                            <tr>
                                <td><font color="red">*</font>仓库</td>
                                <td>
                                    <sys:gridselect url="${ctx}/warehouse/warehouse/warehouse/data" id="warehouse" name="warehouse.id" value="${shelves.warehouse.id}" labelName="warehouse.name" labelValue="${shelves.warehouse.name}"
                                                    title="选择仓库" cssClass="form-control required" fieldLabels="仓库名称|仓库编号" fieldKeys="name|code" searchLabels="仓库名称|仓库编号" searchKeys="name|code" ></sys:gridselect>
                                </td>
                                <td>备注</td>
                                <td>
                                    <form:textarea path="remarks" htmlEscape="false" rows="4" class="form-control "/>
                                </td>
                            </tr>
                        </table>
                    </form:form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        if ("${mode}" !== 'add') {
            $("#remarks").val(jp.escapeHtml($("#remarks").val()));
        }
    })

    function save() {
        var isValidate = jp.validateForm('#inputForm');//校验表单
        if(!isValidate){
            return false;
        }else{
            jp.loading();
            jp.post($("#inputForm").attr('action'),$('#inputForm').serialize(),function(data){
                if(data.success){
                    jp.getParent().refresh();
                    var dialogIndex = parent.layer.getFrameIndex(window.name); // 获取窗口索引
                    parent.layer.close(dialogIndex);
                    jp.success(data.msg)

                }else{
                    jp.error(data.msg);
                }
            })
        }

    }
</script>
</body>
</html>
