<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>货品模块管理</title>
    <meta name="decorator" content="ani"/>
    <link rel="stylesheet" href="${ctxStatic}/common/css/form.css">
    <link rel="stylesheet" href="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.css">
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.js"></script>
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table-zh-CN.js"></script>
    <script type="text/javascript" src="${ctxStatic}/common/js/big.js"></script>
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-body">
                    <form:form id="inputForm" modelAttribute="goods" action="${ctx}/warehouse/goods/goods/save"
                               method="post" class="form-horizontal">
                        <form:hidden path="id"/>
                        <h3 class="text-center">货品表</h3>
<%--                        <div class="header-buttons">--%>
<%--                            <c:if test="${mode == 'add' || mode=='edit'}">--%>
<%--                                <div class="form-group text-right">--%>
<%--                                    <button class="btn btn-primary btn-parsley"--%>
<%--                                            data-loading-text="正在提交...">提 交--%>
<%--                                    </button>--%>
<%--                                </div>--%>
<%--                            </c:if>--%>
<%--                        </div>--%>
                        <table class="table-bordered table main-table">
                            <tr>
                                <td><font color="red">*</font>批次号</td>
                                <td>
                                    <form:input path="batchNum" htmlEscape="false" class="form-control required"/>
                                </td>
                                <td><font color="red">*</font>时间</td>
                                <td>
                                    <div class='input-group form_datetime' id='time'>
                                        <input type='text' name="time" class="form-control required"
                                               value="<fmt:formatDate value="${goods.time}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
                                        <span class="input-group-addon">
								            <span class="glyphicon glyphicon-calendar"></span>
                                        </span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td><font color="red">*</font>操作人</td>
                                <td>
                                    <sys:userselect id="operator" name="operator.id" value="${goods.operator.id}"
                                                    labelName="operator.name" labelValue="${goods.operator.name}"
                                                    cssClass="form-control required" disabled="disabled"/>
                                </td>
                                <td>总价</td>
                                <td>
                                    <form:input path="sum" htmlEscape="false" readonly="true" class="form-control "/>
                                </td>
                            </tr>
                            <tr>
                                <td>备注</td>
                                <td colspan="3">
                                    <form:textarea path="remarks" htmlEscape="false" rows="4" class="form-control "/>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <%@include file="goodsDetail.jsp" %>
                                </td>
                            </tr>
                        </table>
                    </form:form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">

    $(document).ready(function () {
        initTable("#detail_table");
        jp.ajaxForm("#inputForm", function (data) {
            if (data.success) {
                jp.success(data.msg);
                jp.go("${ctx}/warehouse/goods/goods");
            } else {
                jp.error(data.msg);
                $("#inputForm").find("button:submit").button("reset");
            }
        });

        $('#time').datetimepicker({
            format: "YYYY-MM-DD HH:mm:ss"
        });

        if ("${mode}" !== 'add') {
            $("#remarks").val(jp.escapeHtml($("#remarks").val()));
        }
    });
    function save() {
        var isValidate = jp.validateForm('#inputForm');//校验表单
        if(!isValidate){
            return false;
        }else{
            var hasDetails = getTableData().filter(function (e) { return e.delFlag != 1 }).length == 0;
            if(hasDetails){
                jp.warning('请填写明细!');
                return;
            }
            jp.loading();
            jp.post($("#inputForm").attr('action'),$('#inputForm').serialize(),function(data){
                if(data.success){
                    jp.getParent().refresh();
                    var dialogIndex = parent.layer.getFrameIndex(window.name); // 获取窗口索引
                    parent.layer.close(dialogIndex);
                    jp.success(data.msg)

                }else{
                    jp.error(data.msg);
                }
            })
        }

    }
</script>
</body>
</html>
