<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>出库信息管理</title>
    <meta name="decorator" content="ani"/>
    <link rel="stylesheet" href="${ctxStatic}/common/css/form.css">
    <link rel="stylesheet" href="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.css">
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.js"></script>
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table-zh-CN.js"></script>
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-body">
                    <form:form id="inputForm" modelAttribute="outbound" action="${ctx}/warehouse/outbound/outbound/save"
                               method="post" class="form-horizontal">
                        <form:hidden path="id"/>
                        <h3 class="text-center">出库表</h3>
                        <table class="table table-bordered main-table">
                            <tr>
                                <td> <font color="red">*</font>出库单号</td>
                                <td>
                                    <form:input path="number" htmlEscape="false" readonly="true" class="form-control required"/>
                                </td>
                                <td><font color="red">*</font>操作人</td>
                                <td>
                                    <sys:userselect id="operator" name="operator.id"
                                                    value="${outbound.operator.id}" labelName="operator.name"
                                                    labelValue="${outbound.operator.name}" disabled="disabled"
                                                    cssClass="form-control required"/>
                                </td>
                            </tr>

                            <tr>
                                <td> <font color="red">*</font>出库时间</td>
                                <td>
                                    <div class='input-group form_datetime' id='outboundTime'>
                                        <input type='text' name="outboundTime" class="form-control required"
                                               value="<fmt:formatDate value="${outbound.outboundTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
                                        <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
                                    </div>
                                </td>
                                <td>出库分类</td>
                                <td>
                                    <form:select path="type" class="form-control" onchange="onTypeChange(this)">
                                        <form:option value="" label=""/>
                                        <form:options items="${fns:getDictList('wh_delivery_type')}" itemLabel="label"
                                                      itemValue="value" htmlEscape="false"/>
                                    </form:select>
                                </td>
                            </tr>
                            <tr>
                                <td>备注</td>
                                <td colspan="3">
                                    <form:textarea path="remarks" htmlEscape="false" rows="4" class="form-control "/>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <%@include file="outboundDetail.jsp" %>
                                </td>
                            </tr>
                        </table>
                    </form:form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        initTable();
        $('#outboundTime').datetimepicker({
            format: "YYYY-MM-DD HH:mm:ss"
        });
    });
    function save() {
        var isValidate = jp.validateForm('#inputForm');//校验表单
        if(!isValidate){
            return false;
        }else{
            jp.loading();
            jp.post($("#inputForm").attr('action'),$('#inputForm').serialize(),function(data){
                if(data.success){
                    jp.getParent().refresh();
                    var dialogIndex = parent.layer.getFrameIndex(window.name); // 获取窗口索引
                    parent.layer.close(dialogIndex);
                    jp.success(data.msg)

                }else{
                    jp.error(data.msg);
                }
            })
        }

    }

    function onTypeChange(elem){
        var value$ = $(elem).val();
        if(value$ === '1' || value$ === '2'){
            jp.warning("领用出库和盘盈出库只有物资领用和物资盘亏时选择");
            $(elem).val('');
        }
    }
</script>
</body>
</html>