<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp"%>
<html>
<head>
	<title>货品模块管理</title>
	<meta name="decorator" content="ani"/>
	<script type="text/javascript">

		$(document).ready(function() {
			jp.ajaxForm("#inputForm",function(data){
				if(data.success){
				    jp.success(data.msg);
					jp.go("${ctx}/warehouse/goods/goods");
				}else{
				    jp.error(data.msg);
				    $("#inputForm").find("button:submit").button("reset");
				}
			});
			
	        $('#time').datetimepicker({
				 format: "YYYY-MM-DD HH:mm:ss"
		    });
		});
		
		function addRow(list, idx, tpl, row){
			$(list).append(Mustache.render(tpl, {
				idx: idx, delBtn: true, row: row
			}));
			$(list+idx).find("select").each(function(){
				$(this).val($(this).attr("data-value"));
			});
			$(list+idx).find("input[type='checkbox'], input[type='radio']").each(function(){
				var ss = $(this).attr("data-value").split(',');
				for (var i=0; i<ss.length; i++){
					if($(this).val() == ss[i]){
						$(this).attr("checked","checked");
					}
				}
			});
			$(list+idx).find(".form_datetime").each(function(){
				 $(this).datetimepicker({
					 format: "YYYY-MM-DD HH:mm:ss"
			    });
			});
		}
		function delRow(obj, prefix){
			var id = $(prefix+"_id");
			var delFlag = $(prefix+"_delFlag");
			if (id.val() == ""){
				$(obj).parent().parent().remove();
			}else if(delFlag.val() == "0"){
				delFlag.val("1");
				$(obj).html("&divide;").attr("title", "撤销删除");
				$(obj).parent().parent().addClass("error");
			}else if(delFlag.val() == "1"){
				delFlag.val("0");
				$(obj).html("&times;").attr("title", "删除");
				$(obj).parent().parent().removeClass("error");
			}
		}
	</script>
</head>
<body>
<div class="wrapper wrapper-content">				
<div class="row">
	<div class="col-md-12">
	<div class="panel panel-primary">
		<div class="panel-heading">
			<h3 class="panel-title"> 
				<a class="panelButton" href="${ctx}/warehouse/goods/goods"><i class="ti-angle-left"></i> 返回</a>
			</h3>
		</div>
		<div class="panel-body">
		<form:form id="inputForm" modelAttribute="goods" action="${ctx}/warehouse/goods/goods/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
				<div class="form-group">
					<label class="col-sm-2 control-label"><font color="red">*</font>批次号：</label>
					<div class="col-sm-10">
						<form:input path="batchNum" htmlEscape="false"    class="form-control required"/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label"><font color="red">*</font>时间：</label>
					<div class="col-sm-10">
						<div class='input-group form_datetime' id='time'>
							<input type='text'  name="time" class="form-control required"  value="<fmt:formatDate value="${goods.time}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
							<span class="input-group-addon">
								<span class="glyphicon glyphicon-calendar"></span>
							</span>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label"><font color="red">*</font>操作人：</label>
					<div class="col-sm-10">
						<sys:userselect id="operator" name="operator.id" value="${goods.operator.id}" labelName="operator.name" labelValue="${goods.operator.name}"
							    cssClass="form-control required"/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">备注信息：</label>
					<div class="col-sm-10">
						<form:textarea path="remarks" htmlEscape="false" rows="4"    class="form-control "/>
					</div>
				</div>
		<div class="tabs-container">
            <ul class="nav nav-tabs">
				<li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">货品明细：</a>
                </li>
            </ul>
            <div class="tab-content">
				<div id="tab-1" class="tab-pane fade in  active">
			<a class="btn btn-white btn-sm" onclick="addRow('#goodsInfoList', goodsInfoRowIdx, goodsInfoTpl);goodsInfoRowIdx = goodsInfoRowIdx + 1;" title="新增"><i class="fa fa-plus"></i> 新增</a>
			<table class="table table-striped table-bordered table-condensed">
				<thead>
					<tr>
						<th class="hide"></th>
						<th>名称</th>
						<th>类型</th>
						<th>型号</th>
						<th>数量</th>
						<th>备注信息</th>
						<th width="10">&nbsp;</th>
					</tr>
				</thead>
				<tbody id="goodsInfoList">
				</tbody>
			</table>
			<script type="text/template" id="goodsInfoTpl">//<!--
				<tr id="goodsInfoList{{idx}}">
					<td class="hide">
						<input id="goodsInfoList{{idx}}_id" name="goodsInfoList[{{idx}}].id" type="hidden" value="{{row.id}}"/>
						<input id="goodsInfoList{{idx}}_delFlag" name="goodsInfoList[{{idx}}].delFlag" type="hidden" value="0"/>
					</td>
					
					<td>
						<input id="goodsInfoList{{idx}}_name" name="goodsInfoList[{{idx}}].name" type="text" value="{{row.name}}"    class="form-control "/>
					</td>
					
					
					<td>
						<sys:treeselect id="goodsInfoList{{idx}}_type" name="goodsInfoList[{{idx}}].type.id" value="{{row.type.id}}" labelName="goodsInfoList{{idx}}.type.code" labelValue="{{row.type.code}}"
							title="类型" url="/warehouse/materialtype/materialType/treeData" cssClass="form-control  " allowClear="true" />
					</td>
					
					
					<td>
						<input id="goodsInfoList{{idx}}_model" name="goodsInfoList[{{idx}}].model" type="text" value="{{row.model}}"    class="form-control "/>
					</td>
					
					
					<td>
						<input id="goodsInfoList{{idx}}_num" name="goodsInfoList[{{idx}}].num" type="text" value="{{row.num}}"    class="form-control "/>
					</td>
					
					
					<td>
						<textarea id="goodsInfoList{{idx}}_remarks" name="goodsInfoList[{{idx}}].remarks" rows="4"    class="form-control ">{{row.remarks}}</textarea>
					</td>
					
					<td class="text-center" width="10">
						{{#delBtn}}<span class="close" onclick="delRow(this, '#goodsInfoList{{idx}}')" title="删除">&times;</span>{{/delBtn}}
					</td>
				</tr>//-->
			</script>
			<script type="text/javascript">
				var goodsInfoRowIdx = 0, goodsInfoTpl = $("#goodsInfoTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g,"");
				$(document).ready(function() {
					var data = ${fns:toJson(goods.goodsInfoList)};
					for (var i=0; i<data.length; i++){
						addRow('#goodsInfoList', goodsInfoRowIdx, goodsInfoTpl, data[i]);
						goodsInfoRowIdx = goodsInfoRowIdx + 1;
					}
				});
			</script>
			</div>
		</div>
		</div>
		<c:if test="${mode == 'add' || mode=='edit'}">
				<div class="col-lg-3"></div>
		        <div class="col-lg-6">
		             <div class="form-group text-center">
		                 <div>
		                     <button class="btn btn-primary btn-block btn-lg btn-parsley" data-loading-text="正在提交...">提 交</button>
		                 </div>
		             </div>
		        </div>
		</c:if>
		</form:form>
		</div>				
	</div>
	</div>
</div>
</div>
</body>
</html>