/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.profitwarehousing.entity;

import com.jeeplus.modules.warehouse.shelves.entity.Shelves;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;

/**
 * 盘盈入库单明细表Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class ProfitWarehousingInfo extends DataEntity<ProfitWarehousingInfo> {
	
	private static final long serialVersionUID = 1L;
	private ProfitWarehousing profitWarehousing;		// 盘盈入库主表ID
	private String name;		// 名称
	private String type;		// 类型
	private String marking;		// 型号
	private Shelves shelves;		// 货架ID
	
	public ProfitWarehousingInfo() {
		super();
	}

	public ProfitWarehousingInfo(String id){
		super(id);
	}

	public ProfitWarehousingInfo(ProfitWarehousing profitWarehousing) {
		this.profitWarehousing = profitWarehousing;
	}

	@ExcelField(title="盘盈入库主表ID", align=2, sort=1)
	public ProfitWarehousing getProfitWarehousing() {
		return profitWarehousing;
	}

	public void setProfitWarehousing(ProfitWarehousing profitWarehousing) {
		this.profitWarehousing = profitWarehousing;
	}
	
	@ExcelField(title="名称", align=2, sort=2)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@ExcelField(title="类型", align=2, sort=3)
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	@ExcelField(title="型号", align=2, sort=4)
	public String getMarking() {
		return marking;
	}

	public void setMarking(String marking) {
		this.marking = marking;
	}
	
	@ExcelField(title="货架ID", align=2, sort=5)
	public Shelves getShelves() {
		return shelves;
	}

	public void setShelves(Shelves shelves) {
		this.shelves = shelves;
	}
	
}