/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.goods.entity;

import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;
import com.jeeplus.modules.warehouse.goods.entity.Goods;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 货品明细Entity
 * @author huyi
 * @version 2023-02-13
 */
public class GoodsInfo extends DataEntity<GoodsInfo> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 名称
	private MaterialType type;		// 类型
	private String model;		// 型号
	private Integer num;		// 数量
	private Goods goods;		// 主表ID 父类
	private String qrInterval; // 物资编码区间
	private BigDecimal amount; // 单价

	private List<QrCode> qrCodeList; // 二维码集合（xml中无关联查询）
	
	public GoodsInfo() {
		super();
	}

	public GoodsInfo(String id){
		super(id);
	}

	public GoodsInfo(Goods goods){
		this.goods = goods;
	}

	@ExcelField(title="名称", align=2, sort=1)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@ExcelField(title="类型", fieldType=MaterialType.class, value="type.code", align=2, sort=2)
	public MaterialType getType() {
		return type;
	}

	public void setType(MaterialType type) {
		this.type = type;
	}
	
	@ExcelField(title="型号", align=2, sort=3)
	public String getModel() {
		return model;
	}

	public void setModel(String model) {
		this.model = model;
	}
	
	@ExcelField(title="数量", align=2, sort=4)
	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}
	
	@ExcelField(title="单价", align=2, sort=5)
	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
	public Goods getGoods() {
		return goods;
	}

	public void setGoods(Goods goods) {
		this.goods = goods;
	}

	public String getQrInterval() {
		return qrInterval;
	}

	public void setQrInterval(String qrInterval) {
		this.qrInterval = qrInterval;
	}

	public List<QrCode> getQrCodeList() {
		return qrCodeList;
	}

	public void setQrCodeList(List<QrCode> qrCodeList) {
		this.qrCodeList = qrCodeList;
	}

}