/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.ledger.service;

import java.math.BigDecimal;
import java.util.*;

import com.jeeplus.modules.warehouse.ledger.dto.CountLedgerInfo;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.qrcode.mapper.QrCodeMapper;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;
import com.jeeplus.modules.warehouse.shelves.utils.ShelvesUtil;
import com.jeeplus.modules.warehouse.storage.dto.CountStorageInfo;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.ledger.entity.Ledger;
import com.jeeplus.modules.warehouse.ledger.mapper.LedgerMapper;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;
import com.jeeplus.modules.warehouse.ledger.mapper.LedgerInfoMapper;

/**
 * 台账信息Service
 * @author huyi
 * @version 2023-02-13
 */
@Service
@Transactional(readOnly = true)
public class LedgerService extends CrudService<LedgerMapper, Ledger> {

	@Autowired
	private LedgerInfoMapper ledgerInfoMapper;
	@Autowired
	private QrCodeMapper qrCodeMapper;
	
	public Ledger get(String id) {
		Ledger ledger = super.get(id);
		List<LedgerInfo> ledgerInfoList = ledgerInfoMapper.findList(new LedgerInfo(ledger));
		ledger.setLedgerInfoList(ledgerInfoList);
		for (LedgerInfo li : ledgerInfoList) {
			List<Shelves> shelvesList = ShelvesUtil.getShelvesListByIds(li.getShelvesIds());
			li.setShelvesList(shelvesList);
			List<Warehouse> warehouseList = ShelvesUtil.getWarehouseListByIds(li.getWarehouseIds());
			li.setWarehouseList(warehouseList);
		}
		return ledger;
	}

	
	public List<Ledger> findList(Ledger ledger) {
		return super.findList(ledger);
	}
	
	public Page<Ledger> findPage(Page<Ledger> page, Ledger ledger) {
		return super.findPage(page, ledger);
	}

	public Page<LedgerInfo> findInfoPage(Page<LedgerInfo> page, LedgerInfo ledgerInfo) {
		dataRuleFilter(ledgerInfo);
		ledgerInfo.setPage(page);
		page.setList(ledgerInfoMapper.findList(ledgerInfo));
		return page;
	}

	@Transactional(readOnly = false)
	public void save(Ledger ledger) {
		Ledger oldLeger = mapper.findByTypeAndModel(ledger);
		// 判断是否存在同名称、同类型、同型号的台账，如果不存在，做新增操作，如果存在，则做修改操作
		if (null == oldLeger || StringUtils.isBlank(oldLeger.getId())) {
			super.save(ledger);
		} else {
			int num = ledger.getNum();
			BigDecimal sum = ledger.getSum();

			oldLeger.setNum(oldLeger.getNum() + num);
			oldLeger.setSum(oldLeger.getSum().add(sum));
			List<LedgerInfo> oldLedgerInfos = oldLeger.getLedgerInfoList();
			if (null != oldLedgerInfos) {
				List<LedgerInfo> newLedgerInfos = new ArrayList<>();
				newLedgerInfos.addAll(oldLedgerInfos);
				newLedgerInfos.addAll(ledger.getLedgerInfoList());
				oldLeger.setLedgerInfoList(newLedgerInfos);
			}

			oldLeger.preUpdate();
			mapper.update(oldLeger);
			ledger = oldLeger;
		}
		for (LedgerInfo ledgerInfo : ledger.getLedgerInfoList()){
			if (ledgerInfo.getId() == null){
				continue;
			}
			if (LedgerInfo.DEL_FLAG_NORMAL.equals(ledgerInfo.getDelFlag())){
				if (StringUtils.isBlank(ledgerInfo.getId())){
					QrCode qrCode = ledgerInfo.getQr();
					QrCode qc = qrCodeMapper.get(qrCode);
					qc.setState("2");
					qrCodeMapper.update(qc);
					ledgerInfo.setLedger(ledger);
					ledgerInfo.preInsert();
					ledgerInfoMapper.insert(ledgerInfo);
				}else{
					ledgerInfo.preUpdate();
					ledgerInfoMapper.update(ledgerInfo);
				}
			}else{
				ledgerInfoMapper.delete(ledgerInfo);
			}
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(Ledger ledger) {
		super.delete(ledger);
		ledgerInfoMapper.delete(new LedgerInfo(ledger));
	}
	/*
	* 张吕涛
	* 领用后下账,更新台账货架信息
	* */
	@Transactional(readOnly = false)
	public void lowerLedger(Ledger ledger) {
		List<String> shelvesListByLedgerId = mapper.findShelvesListByLedgerId(ledger.getId());
		if(shelvesListByLedgerId == null || shelvesListByLedgerId.size() == 0){
			ledger.setShelvesIds(null);
		}else {
			String shelvesIds = String.join(",", shelvesListByLedgerId);
			ledger.setShelvesIds(shelvesIds);
		}
		mapper.update(ledger);
	}
	@Transactional(readOnly = false)
	public LedgerInfo findByQrOrCode(LedgerInfo ledgerInfo) {
		List<LedgerInfo> ledgerInfoList = ledgerInfoMapper.findListByQrIdAndCode(ledgerInfo);
		if (null != ledgerInfoList && ledgerInfoList.size() > 0) {
			return ledgerInfoList.get(0);
		} else {
			return null;
		}
	}
	
}