/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.ledger.entity;

import com.jeeplus.modules.warehouse.goods.entity.GoodsInfo;
import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;

import java.math.BigDecimal;
import java.util.List;

/**
 * 台账明细Entity
 * @author huyi
 * @version 2023-02-13
 */
public class LedgerInfo extends DataEntity<LedgerInfo> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 物资名称
	private MaterialType type;		// 类型
	private String model;		// 型号
	private String batchNum;		// 批次号
	private Ledger ledger;		// 主表外键 父类
	private GoodsInfo goodsInfo;		// 货品明细
	private QrCode qr;		// 二维码id

	private String code;		// 物资编码
	private BigDecimal amount; // 单价
	private int num; // 数量

	private String shelvesIds;
	private String warehouseIds;

	private List<Shelves> shelvesList;
	private List<Warehouse> warehouseList;

	private Shelves shelves;

	public LedgerInfo() {
		super();
	}

	public LedgerInfo(String id){
		super(id);
	}

	public LedgerInfo(Ledger ledger){
		this.ledger = ledger;
	}

	@ExcelField(title="物资名称", align=2, sort=1)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@ExcelField(title="类型", fieldType=MaterialType.class, value="type.code", align=2, sort=2)
	public MaterialType getType() {
		return type;
	}

	public void setType(MaterialType type) {
		this.type = type;
	}
	
	@ExcelField(title="型号", align=2, sort=3)
	public String getModel() {
		return model;
	}

	public void setModel(String model) {
		this.model = model;
	}
	
	@ExcelField(title="批次号", align=2, sort=4)
	public String getBatchNum() {
		return batchNum;
	}

	public void setBatchNum(String batchNum) {
		this.batchNum = batchNum;
	}
	
	public Ledger getLedger() {
		return ledger;
	}

	public void setLedger(Ledger ledger) {
		this.ledger = ledger;
	}
	@ExcelField(title="货品明细id", align=2, sort=6)
	public GoodsInfo getGoodsInfo() {
		return goodsInfo;
	}

	public void setGoodsInfo(GoodsInfo goodsInfo) {
		this.goodsInfo = goodsInfo;
	}

	@ExcelField(title="二维码id", align=2, sort=7)
	public QrCode getQr() {
		return qr;
	}

	public void setQr(QrCode qr) {
		this.qr = qr;
	}

	
	@ExcelField(title="物资编码", align=2, sort=9)
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@ExcelField(title="单价", align=2, sort=10)
	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public int getNum() {
		return num;
	}

	public void setNum(int num) {
		this.num = num;
	}

	public String getShelvesIds() {
		return shelvesIds;
	}

	public void setShelvesIds(String shelvesIds) {
		this.shelvesIds = shelvesIds;
	}

	public String getWarehouseIds() {
		return warehouseIds;
	}

	public void setWarehouseIds(String warehouseIds) {
		this.warehouseIds = warehouseIds;
	}

	public List<Shelves> getShelvesList() {
		return shelvesList;
	}

	public void setShelvesList(List<Shelves> shelvesList) {
		this.shelvesList = shelvesList;
	}

	public List<Warehouse> getWarehouseList() {
		return warehouseList;
	}

	public void setWarehouseList(List<Warehouse> warehouseList) {
		this.warehouseList = warehouseList;
	}

    public Shelves getShelves() {
        return shelves;
    }

    public void setShelves(Shelves shelves) {
        this.shelves = shelves;
    }
}