/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialloss.entity;


import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;

/**
 * 盘亏明细表Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class MaterialLossInfo extends DataEntity<MaterialLossInfo> {
	
	private static final long serialVersionUID = 1L;
	private MaterialLoss materialLoss;		// 盘亏表主表ID
	private LedgerInfo ledgerInfo;		// 物资台账明细ID
	
	public MaterialLossInfo() {
		super();
	}

	public MaterialLossInfo(String id){
		super(id);
	}

	public MaterialLossInfo(MaterialLoss materialLoss) {
		this.materialLoss = materialLoss;
	}

	public MaterialLossInfo(String id, LedgerInfo ledgerInfo) {
		super(id);
		this.ledgerInfo = ledgerInfo;
	}

	public MaterialLossInfo(LedgerInfo ledgerInfo) {
		this.ledgerInfo = ledgerInfo;
	}

	@ExcelField(title="盘亏表主表ID", align=2, sort=1)
	public MaterialLoss getMaterialLoss() {
		return materialLoss;
	}

	public void setMaterialLoss(MaterialLoss materialLoss) {
		this.materialLoss = materialLoss;
	}
	
	@ExcelField(title="物资台账明细ID", align=2, sort=2)
	public LedgerInfo getLedgerInfo() {
		return ledgerInfo;
	}

	public void setLedgerInfo(LedgerInfo ledgerInfo) {
		this.ledgerInfo = ledgerInfo;
	}
	
}