<%--
  Created by IntelliJ IDEA.
  User: yangzi
  Date: 2023/2/21
  Time: 10:29
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<div id="toolbar" class="text-left">
    <c:if test="${mode == 'add' || mode == 'edit'}">
        <a class="btn btn-primary btn-sm" onclick="addDetail('#detail_table')" title="新增"><i class="fa fa-plus"></i>
            添加</a>
    </c:if>
</div>
<table id="detail_table" data-toolbar="#toolbar"></table>
<script>
    var selector = "#detail_table";

    function initTable() {
        var data = ${fns:toJson(materialLoss.materialLossInfoList)};
        if(data.length){
            data = data.map(function(item){
                item.delFlag = 0;
                item.ledgerInfo.shelvesNames = item.ledgerInfo.shelvesList.map(function (e) { return e.name }).join(',') + ',';
                item.ledgerInfo.warehouseNames = item.ledgerInfo.warehouseList.map(function (e) { return e.name }).join(',') + ',';
                item.remarks = jp.escapeHtml(item.remarks);
                return item;
            })
        }
        $(selector).bootstrapTable({
            data: data,
            columns: [{checkbox: true},
                {
                    field: 'no',
                    title: '序号',
                    align: 'center',
                    width: 60,
                    formatter: function (value, row, index) {
                        var tpl = $("#hideTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, "");
                        var html = Mustache.render(tpl, {
                            idx: index,
                            row: row
                        })

                        return html + '<span>' + (index + 1) + '</span>'
                    }
                },
                {
                    field: 'ledgerInfo.code',
                    title: '物资编码',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoCodeTpl").html(), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.type.name',
                    title: '品名',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoTypeTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.type.code',
                    title: '代码',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoTypeCodeTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.model',
                    title: '型号',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoModelTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.amount',
                    title: '单价',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoAmountTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.type.unit',
                    title: '单位',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoTypeUnitTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.batchNum',
                    title: '批次号',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoBatchNumTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.warehouseNames',
                    title: '仓库',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoWarehouseTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'ledgerInfo.shelvesNames',
                    title: '货架',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#ledgerInfoShelvesTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: 'remarks',
                    title: '备注',
                    formatter: function (value, row, index) {
                        return Mustache.render($("#remarksTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""), {
                            row: row,
                            idx: index
                        })
                    }
                },
                {
                    field: '',
                    title: '操作',
                    formatter: function (value, row, index) {
                        var text = row.delFlag == 1 ? '撤销删除' : '删除';
                        var result = ["<a href='javascript:void(0);' onclick=\"removeRow(" + index + ", '" + row.id + "',  '" + row.delFlag + "')\">" + text + "</a>"]
                        return result.join('');
                    }
                }
            ]
        });
    }

    function getSelections() {
        return $(selector).bootstrapTable('getSelections');
    }

    /**
     * 手动添加明细
     * @param selector
     */
    function addDetail(selector) {
        jp.openGridSelectDialog({
            title: '选择物资台账明细',
            isMultiSelect: true,
            url: "${ctx}/warehouse/ledger/ledger/findByQrOrCode",
            fieldLabels: "物资编码|品名|品名代码|型号|批次号|单价|数量|单位",
            fieldKeys: "code|type.name|type.code|model|batchNum|amount|num|type.unit",
            searchLabels: "物资编码",
            searchKeys: "code",
        }, function (items) {
            if (Array.isArray(items)) {
                /***
                 * 重复的物资编码去重
                 */
                var newItems = [];
                items.forEach(function(item){
                    var fined = getTableData().find(function(v){
                        return v.ledgerInfo.code === item.code
                    })
                    if(!fined){
                        newItems.push(item);
                    }else{
                        jp.warning('重复的物资不能添加！');
                    }
                });
                var data = newItems.map(function (item) {
                    item[0] = false;
                    return {
                        id: '',
                        delFlag: 0,
                        remarks: '',
                        ledgerInfo: Object.assign({}, item, {
                            'shelvesNames': item.shelvesList.map(function (e) { return e.name }).join(',') + ',',
                            'warehouseNames': item.warehouseList.map(function (e) { return e.name }).join(',') + ',',
                        })
                    }
                })
                $(selector).bootstrapTable('append', data)
            }
        })
    }

    function removeRow(index, rowId, rowDelFlag) {
        if (rowId) {
            var delFlag = rowDelFlag == 1 ? 0 : 1
            updateRow(index, {
                delFlag: delFlag
            })
        } else {
            $(selector).bootstrapTable("remove", {
                field: '$index',
                values: [index]
            })
        }
    }

    function updateRow(index, row) {
        $(selector).bootstrapTable('updateRow', {
            index: index,
            row: row
        })
    }

    function onInputChange(rowIndex, elem, field) {
        var obj = {};
        obj[field] = $(elem).val();
        updateRow(rowIndex, obj);
    }
    
    /**
     * 获取所有明细数据
     * @returns {*|jQuery}
     */
    function getTableData() {
        return $(selector).bootstrapTable('getData');
    }
</script>

<script id="hideTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_id" name="materialLossInfoList[{{idx}}].id" type="hidden"
           value="{{row.id}}"/>
    <input id="materialLossInfoList{{idx}}_delFlag" name="materialLossInfoList[{{idx}}].delFlag"
           type="hidden" value="{{row.delFlag}}"/>
    <input id="materialLossInfoList{{idx}}_materialLoss"
           name="materialLossInfoList[{{idx}}].materialLoss.id" type="hidden"
           value="{{row.materialLoss.id}}"/>
    <input id="materialLossInfoList{{idx}}_ledgerInfoId"
           name="materialLossInfoList[{{idx}}].ledgerInfo.id" type="hidden" value="{{row.ledgerInfo.id}}"/>
</script>

<script id="ledgerInfoNameTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoName" readonly
           name="materialLossInfoList[{{idx}}].ledgerInfo.name" type="text" class="form-control"
           value="{{row.ledgerInfo.name}}"/>
</script>
<script id="ledgerInfoCodeTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoCode" readonly
           name="materialLossInfoList[{{idx}}].ledgerInfo.code" type="text" class="form-control"
           value="{{row.ledgerInfo.code}}"/>
</script>

<script id="ledgerInfoTypeTpl" type="text/html">//<!--
    <sys:treeselect id="materialLossInfoList{{idx}}_ledgerInfoType" name="materialLossInfoList[{{idx}}].ledgerInfo.type.id" value="{{row.ledgerInfo.type.id}}" labelName="materialLossInfoList{{idx}}.ledgerInfo.type.name" labelValue="{{row.ledgerInfo.type.name}}"
							title="品名代码" url="/warehouse/materialtype/materialType/treeData" cssClass="form-control  " disabled="disabled" allowClear="true"/>//-->
</script>
<script id="ledgerInfoTypeCodeTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoTypeCode"
           name="materialLossInfoList[{{idx}}].ledgerInfo.type.code" type="text" class="form-control" readonly
           value="{{row.ledgerInfo.type.code}}"/>
</script>
<script id="ledgerInfoTypeUnitTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoTypeUnit"
           name="materialLossInfoList[{{idx}}].ledgerInfo.type.unit" type="text" class="form-control" readonly
           value="{{row.ledgerInfo.type.unit}}"/>
</script>
<script id="ledgerInfoModelTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoModel"
           name="materialLossInfoList[{{idx}}].ledgerInfo.model" type="text" class="form-control" readonly
           value="{{row.ledgerInfo.model}}"/>
</script>
<script id="ledgerInfoAmountTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoAmount"
           name="materialLossInfoList[{{idx}}].ledgerInfo.amount" type="text" readonly class="form-control"
           value="{{row.ledgerInfo.amount}}"/>
</script>
<script id="ledgerInfoWarehouseTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoWarehouse"
           name="materialLossInfoList[{{idx}}].ledgerInfo.warehouseNames" type="text" readonly class="form-control"
           value="{{row.ledgerInfo.warehouseNames}}"/>
    <input type="hidden" name="materialLossInfoList[{{idx}}].ledgerInfo.warehouseIds" value="{{row.ledgerInfo.warehouseIds}}">
</script>
<script id="ledgerInfoShelvesTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoShelves"
           name="materialLossInfoList[{{idx}}].ledgerInfo.shelvesNames" type="text" readonly class="form-control"
           value="{{row.ledgerInfo.shelvesNames}}"/>
    <input type="hidden" name="materialLossInfoList[{{idx}}].ledgerInfo.shelvesIds" value="{{row.ledgerInfo.shelvesIds}}">
</script>
<%----%>
<script id="ledgerInfoBatchNumTpl" type="text/html">
    <input id="materialLossInfoList{{idx}}_ledgerInfoBatchNum"
           name="materialLossInfoList[{{idx}}].ledgerInfo.batchNum" type="text" readonly class="form-control"
           value="{{row.ledgerInfo.batchNum}}"/>
</script>
<script id="remarksTpl" type="text/html">
    <textarea id="storageInfoList{{idx}}_remarks" name="storageInfoList[{{idx}}].remarks" rows="2"
              onchange="onInputChange('{{idx}}', this, 'remarks')" class="form-control ">{{row.remarks}}</textarea>
</script>
