<style>
    #scanIpt_ {
        position: absolute;
        top: -10000px;
        left: 0;
        opacity: 0;
    }
</style>

<input id="scanIpt_" type="text" />


<script>

// function Scan () {
//     this.scanIptFocusTimer$ = null;
//     this.inputMethodCnType$ = false;
//
//     $(document).ready(function () {
//         var ipt = getScanIpt();
//         document.addEventListener('visibilitychange', pageVisible);
//         ipt.addEventListener('change', scanDataChange);
//         ipt.addEventListener('compositionstart', iptCompositionstart);
//         ipt.addEventListener('compositionend', iptCompositionend);
//         scanIptGetFocusStart();
//     })
// }

var scanIptFocusTimer$ = null;
var inputMethodCnType$ = false;
var focusStop = true;

$(document).ready(function () {
    $(document.body).on('focusin', function (e) {
        var dom = e.target;
        if (dom.id === 'scanIpt_') return;
        scanIptGetFocusStop();
    })
    $(document.body).on('focusout', function (e) {
        var dom = e.target;
        if (dom.id === 'scanIpt_') return;
        scanIptGetFocusStart();
    })
})

function scanStart () {
    var ipt = getScanIpt();
    focusStop = false;
    ipt.focus();
    document.addEventListener('visibilitychange', pageVisible);
    ipt.addEventListener('change', scanDataChange);
    ipt.addEventListener('compositionstart', iptCompositionstart);
    ipt.addEventListener('compositionend', iptCompositionend);
    scanIptGetFocusStart();
    // var allFormDom = $("input, select, textarea");
    // allFormDom.on('focus', function () {
    //     if (this.id === 'scanIpt_') return;
    //     scanIptGetFocusStop();
    // })
    // allFormDom.on('blur', function () {
    //     if (this.id === 'scanIpt_') return;
    //     scanIptGetFocusStart();
    // })
}

function scanStop () {
    focusStop = true;
    var ipt = getScanIpt();
    ipt.removeEventListener('change', scanDataChange);
    ipt.removeEventListener('compositionstart', iptCompositionstart);
    scanIptGetFocusStop();
    document.removeEventListener('visibilitychange', pageVisible);
}

window.onbeforeunload = function (e) {
    scanStop();
}

// $(document).ready(function () {
//     var ipt = getScanIpt();
//     document.addEventListener('visibilitychange', pageVisible);
//     ipt.addEventListener('change', scanDataChange);
//     ipt.addEventListener('compositionstart', iptCompositionstart);
//     ipt.addEventListener('compositionend', iptCompositionend);
// })

function getScanIpt () {
    return document.getElementById("scanIpt_");
}

function pageVisible () {
    var state = document.visibilityState;
    if (state === 'visible') {
        scanIptGetFocusStart();
    } else if (state === 'hidden') {
        scanIptGetFocusStop();
    }
}


function scanIptGetFocusStart () {
    if (focusStop) return;
    var ipt = getScanIpt();
    if (ipt) {
        scanIptFocusTimer$ = iptFocus(ipt);
    }
}

function scanIptGetFocusStop () {
    if (scanIptFocusTimer$) {
        clearInterval(scanIptFocusTimer$);
        scanIptFocusTimer$ = null;
    }
}



function iptFocus () {
    var ipt = getScanIpt();
    var timer = setInterval(function () {
        if (ipt !== document.activeElement && scanIptFocusTimer$) {
            ipt.focus();
        }
    }, 300);
    return timer;
}

function iptCompositionstart () {
    inputMethodCnType = true;
}

function iptCompositionend () {
    var ipt = getScanIpt();
    if (inputMethodCnType$) {
        jp.alert('请将输入法设置为英文');
        inputMethodCnType$ = false;
        ipt.value = '';
    }
}

function scanDataChange () {
    var elem = getScanIpt();
    var val = $(elem).val();
    if (!val) {
        return;
    }
    try {
        window.scanIptChangeCallback && window.scanIptChangeCallback(val);
    } catch (e) {}
    setTimeout(function () {
        $(elem).val('');
        $(elem).blur();
    }, 100)
}

</script>
