/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.ledger.mapper;

import com.jeeplus.core.persistence.BaseMapper;
import com.jeeplus.core.persistence.annotation.MyBatisMapper;
import com.jeeplus.modules.warehouse.ledger.entity.Ledger;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 台账信息MAPPER接口
 * @author huyi
 * @version 2023-02-13
 */
@MyBatisMapper
public interface LedgerMapper extends BaseMapper<Ledger> {

    public Ledger findByType(Ledger ledger);
    //zlt 查询台账主表的货架集合
    public List<String> findShelvesListByLedgerId(@Param("id") String id);
}