<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>台账信息管理</title>
    <meta name="decorator" content="ani"/>
    <link rel="stylesheet" href="${ctxStatic}/common/css/form.css">
    <link rel="stylesheet" href="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.css">
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.js"></script>
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table-zh-CN.js"></script>
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-body">
                    <form:form id="inputForm" modelAttribute="ledger" action="${ctx}/warehouse/ledger/ledger/save"
                               method="post" class="form-horizontal">
                        <form:hidden path="id"/>
                        <h3 class="text-center">台账表</h3>
                        <table class="table table-bordered main-table">
                            <tr>
                                <td>物资名称</td>
                                <td>
                                    <form:input path="name" htmlEscape="false" class="form-control "/>
                                </td>
                                <td>类型</td>
                                <td>
                                    <sys:treeselect id="type" name="type.id" value="${ledger.type.id}" labelName="type.name"
                                                    labelValue="${ledger.type.name}"
                                                    title="类型" url="/warehouse/materialtype/materialType/treeData"
                                                    extId="${ledger.id}" cssClass="form-control " allowClear="true"/>
                                </td>
                            </tr>
                            <tr>
                                <td>型号</td>
                                <td>
                                    <form:input path="model" htmlEscape="false" class="form-control "/>
                                </td>
                                <td>数量</td>
                                <td>
                                    <form:input path="num" htmlEscape="false" class="form-control "/>
                                </td>
                            </tr>
                            <tr>
                                <td>总价</td>
                                <td>
                                    <form:input path="sum" htmlEscape="false" class="form-control "/>
                                </td>
                                <td colspan="2"></td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <%@include file="ledgerDetail.jsp" %>
                                </td>
                            </tr>
                        </table>
                    </form:form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        initTable();
    });
    function save() {
        var isValidate = jp.validateForm('#inputForm');//校验表单
        if(!isValidate){
            return false;
        }else{
            jp.loading();
            jp.post($("#inputForm").attr('action'),$('#inputForm').serialize(),function(data){
                if(data.success){
                    jp.getParent().refresh();
                    var dialogIndex = parent.layer.getFrameIndex(window.name); // 获取窗口索引
                    parent.layer.close(dialogIndex);
                    jp.success(data.msg)

                }else{
                    jp.error(data.msg);
                }
            })
        }

    }
</script>
</body>
</html>