/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialtype.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import javax.validation.constraints.NotNull;

import com.jeeplus.core.persistence.TreeEntity;

/**
 * 物资类型Entity
 * @author zhnaglt
 * @version 2023-02-13
 */
public class MaterialType extends TreeEntity<MaterialType> {
	
	private static final long serialVersionUID = 1L;
	private String code;		// 物资类型编码
	
	
	public MaterialType() {
		super();
	}

	public MaterialType(String id){
		super(id);
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	public  MaterialType getParent() {
			return parent;
	}
	
	@Override
	public void setParent(MaterialType parent) {
		this.parent = parent;
		
	}
	
	public String getParentId() {
		return parent != null && parent.getId() != null ? parent.getId() : "0";
	}
}