/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.shelves.entity;


import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;

/**
 * 货架信息Entity
 * @author zhanglt
 * @version 2023-02-13
 */
public class Shelves extends DataEntity<Shelves> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 货架名称
	private String number;		// 货架编号
	private Warehouse warehouse;		// 仓库id
	
	public Shelves() {
		super();
	}

	public Shelves(String id){
		super(id);
	}

	@ExcelField(title="货架名称", align=2, sort=1)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@ExcelField(title="货架编号", align=2, sort=2)
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@ExcelField(title="仓库id", dictType="", align=2, sort=3)
	public Warehouse getWarehouse() {
		return warehouse;
	}

	public void setWarehouse(Warehouse warehouse) {
		this.warehouse = warehouse;
	}
	
}