/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialtype.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.service.TreeService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;
import com.jeeplus.modules.warehouse.materialtype.mapper.MaterialTypeMapper;

/**
 * 物资类型Service
 * @author zhnaglt
 * @version 2023-02-13
 */
@Service
@Transactional(readOnly = true)
public class MaterialTypeService extends TreeService<MaterialTypeMapper, MaterialType> {

	public MaterialType get(String id) {
		return super.get(id);
	}
	
	public List<MaterialType> findList(MaterialType materialType) {
		if (StringUtils.isNotBlank(materialType.getParentIds())){
			materialType.setParentIds(","+materialType.getParentIds()+",");
		}
		return super.findList(materialType);
	}
	
	@Transactional(readOnly = false)
	public void save(MaterialType materialType) {
		super.save(materialType);
	}
	
	@Transactional(readOnly = false)
	public void delete(MaterialType materialType) {
		super.delete(materialType);
	}
	
}