package com.jeeplus.modules.warehouse.code.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class StaticNumSeq {
    /**
     * 购置申请
     * */
    public final static String GZSQ = "GZSQ";
    /**
     * 购置备案
     * */
    public final static String GZBA = "GZBA";

    /**
     * 批次号
     */
    public final static String PC = "PC";

    /**
     * 二维码物资编码
     */
    public final static String WZBM = "WZBM";

    /**
     * 入库单
     */
    public final static String RKD = "RKD";

    public static List<String> seqList(){
        List<String> seqList = new ArrayList<>();
        Class<StaticNumSeq> clz = StaticNumSeq.class;
        Field[] fields = clz.getFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                if(field.getType().toString().endsWith("java.lang.String") && Modifier.isStatic(field.getModifiers()))
                   seqList.add(field.getName());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return seqList;
    }

    private static final Class getCurrentClass(){
        return new Object(){
            public Class getClassForStatic(){
                return this.getClass();
            }
        }.getClassForStatic();
    }
}
