/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialloss.entity;

import java.util.List;
import com.google.common.collect.Lists;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.sys.entity.User;

import java.util.Date;

/**
 * 物资盘亏记录Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class MaterialLoss extends DataEntity<MaterialLoss> {
	
	private static final long serialVersionUID = 1L;
	private String number;		// 盘亏单号
	private User operator;		// 操作人
	private Date time;		// 盘亏时间
	private String beginTime;		// 开始 盘亏时间
	private String endTime;		// 结束 盘亏时间
	private List<MaterialLossInfo> materialLossInfoList = Lists.newArrayList();		// 子表列表
	
	public MaterialLoss() {
		super();
	}

	public MaterialLoss(String id){
		super(id);
	}

	@ExcelField(title="盘亏单号", align=2, sort=1)
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@ExcelField(title="操作人", align=2, sort=2)
	public User getOperator() {
		return operator;
	}

	public void setOperator(User operator) {
		this.operator = operator;
	}
	
	@ExcelField(title="盘亏时间", align=2, sort=3)
	public Date getTime() {
		return time;
	}

	public void setTime(Date time) {
		this.time = time;
	}
	
	public String getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}
	
	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}
		
	public List<MaterialLossInfo> getMaterialLossInfoList() {
		return materialLossInfoList;
	}

	public void setMaterialLossInfoList(List<MaterialLossInfo> materialLossInfoList) {
		this.materialLossInfoList = materialLossInfoList;
	}
}