<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>二维码管理</title>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <meta name="decorator" content="ani"/>
    <%@ include file="/webpage/include/bootstraptable.jsp" %>
    <%@include file="/webpage/include/treeview.jsp" %>
    <%@include file="/webpage/include/logic.jsp" %>
    <%@include file="qrCodeList.js" %>
    <script>
        var projectName = "${ctxStatic}";
    </script>
    <script type="text/javascript" src="${ctxStatic}/common/js/LodopFuncs.js"></script>
    <%--<object  id="LODOP_OB" classid="clsid:2105C259-1E0C-4534-8141-A753534CB4CA" width=0 height=0>
        <embed id="LODOP_EM" type="application/x-print-lodop" width=0 height=0></embed>
    </object>--%>
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="panel panel-primary">
        <div class="panel-heading">
            <h3 class="panel-title">二维码列表</h3>
        </div>
        <div class="panel-body">

            <!-- 搜索 -->
            <div id="search-collapse" class="collapse show">
                <div class="accordion-inner">
                    <form:form id="searchForm" modelAttribute="qrCode" class="form form-horizontal well clearfix">
                        <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
                            <label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="物资编码：">物资编码：</label>
                            <div class="col-lg-8 col-md-8">
                                <form:input path="code" htmlEscape="false" maxlength="64" class=" form-control"/>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
                            <label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="物资名称：">物资名称：</label>
                            <div class="col-lg-8 col-md-8">
                                <form:input path="goodsInfo.name" htmlEscape="false" maxlength="64" class=" form-control"/>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
                            <label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="品名代码：">品名代码：</label>
                            <div class="col-lg-8 col-md-8">
                                <sys:treeselect id="type" name="goodsInfo.type.id" value="${qrCode.goodsInfo.type.id}" labelName="goodsInfo.type.name" labelValue="${qrCode.goodsInfo.type.name}"
                                                title="品名代码" url="/warehouse/materialtype/materialType/treeData" cssClass="form-control" allowClear="true" allowSearch="true" />
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
                            <label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="型号：">型号：</label>
                            <div class="col-lg-8 col-md-8">
                                <form:input path="goodsInfo.model" htmlEscape="false" maxlength="64" class=" form-control"/>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
                            <label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="批次号：">批次号：</label>
                            <div class="col-lg-8 col-md-8">
                                <form:input path="goodsInfo.goods.batchNum" htmlEscape="false" maxlength="64" class=" form-control"/>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-2 col-lg-2">
                            <div style="margin-top:0px">
                                <a id="search" class="btn btn-primary btn-rounded  btn-bordered btn-sm"><i
                                        class="fa fa-search"></i> 查询</a>
                                <a id="reset" class="btn btn-primary btn-rounded  btn-bordered btn-sm"><i
                                        class="fa fa-refresh"></i> 重置</a>
                            </div>
                        </div>
                    </form:form>
                </div>
            </div>

            <!-- 工具栏 -->
            <div id="toolbar">
                <shiro:hasPermission name="warehouse:qrcode:qrCode:add">
                    <button id="add" class="btn btn-primary" onclick="add()">
                        <i class="glyphicon glyphicon-plus"></i> 新建
                    </button>
                </shiro:hasPermission>
                <shiro:hasPermission name="warehouse:qrcode:qrCode:edit">
                    <button id="edit" class="btn btn-success" disabled onclick="edit()">
                        <i class="glyphicon glyphicon-edit"></i> 修改
                    </button>
                </shiro:hasPermission>
                <shiro:hasPermission name="warehouse:qrcode:qrCode:del">
                    <button id="remove" class="btn btn-danger" disabled onclick="deleteAll()">
                        <i class="glyphicon glyphicon-remove"></i> 删除
                    </button>
                </shiro:hasPermission>
<%--                <shiro:hasPermission name="warehouse:qrcode:qrCode:import">--%>
<%--                    <button id="btnImport" class="btn btn-info"><i class="fa fa-folder-open-o"></i> 导入</button>--%>
<%--                </shiro:hasPermission>--%>
<%--                <shiro:hasPermission name="warehouse:qrcode:qrCode:export">--%>
<%--                    <button id="export" class="btn btn-warning">--%>
<%--                        <i class="fa fa-file-excel-o"></i> 导出--%>
<%--                    </button>--%>
<%--                </shiro:hasPermission>--%>
                <shiro:hasPermission name="warehouse:qrcode:qrCode:view">
                    <button id="view" class="btn btn-default" disabled onclick="view()">
                        <i class="fa fa-search-plus"></i> 查看
                    </button>
                </shiro:hasPermission>
<%--                <button id="printAll" class="btn btn-primary" disabled onclick="onPrint()">--%>
<%--                    <i class="fa fa-search-plus"></i> 批量打印--%>
<%--                </button>--%>
            </div>

            <!-- 表格 -->
            <table id="qrCodeTable" data-toolbar="#toolbar"></table>

            <!-- context menu -->
            <ul id="context-menu" class="dropdown-menu">
                <shiro:hasPermission name="warehouse:qrcode:qrCode:view">
                    <li data-item="view"><a>查看</a></li>
                </shiro:hasPermission>
                <shiro:hasPermission name="warehouse:qrcode:qrCode:edit">
                    <li data-item="edit"><a>编辑</a></li>
                </shiro:hasPermission>
                <shiro:hasPermission name="warehouse:qrcode:qrCode:del">
                    <li data-item="delete"><a>删除</a></li>
                </shiro:hasPermission>
                <li data-item="action1"><a>取消</a></li>
            </ul>
        </div>
    </div>
</div>
</body>
</html>
