<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>手写板</title>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <meta name="decorator" content="ani"/>
    <%@include file="/webpage/include/writingPad.jsp"%>
    <style>
        .btnBox {
            padding: 20px;
        }
        .startSign {
            display: none;
        }
        .signAgain {
            display: none;
        }
        canvas {
            background: #0e90d2;
            /*width: 600px;*/
            /*height: 400px;*/
            /*margin: 0 auto;*/
        }
    </style>
</head>
<body>
<div class="page">
    <div class="btnBox">
        <button class="btn btn-success startSign">签字</button>
        <button class="btn btn-primary signAgain">重新签字</button>
    </div>
    <div class="imgBox">
        <canvas id="myCanvas"></canvas>
    </div>
</div>
<script>

$(".startSign").on('click', function () {
    init();
})

$(".signAgain").on('click', function () {
    canvasInit();
    clear();
    init();
    base64Str = '';
})

$(document).ready(function () {
    init();
    canvasInit();
})



function init () {
    getDevice(function (result) {
        if (result) {
            $(".startSign").hide();
        } else {
            $(".startSign").show();
        }
    });
}

var base64Str = '';

function getSignImg (result) {
    let img = new Image();
    img.src = result.message;
    base64Str = result.message;
    var canvas = document.getElementById("myCanvas");
    var ctx = canvas.getContext('2d');
    img.onload = function () {
        // 等比例缩放图片
        var scale = 1;
        var tt = 1000; // 可以根据具体的要求去设定
        if (this.width > tt || this.height > tt) {
            if (this.width > this.height) {
                scale = tt / this.width;
            } else {
                scale = tt / this.height;
            }
        }
        ctx.width = this.width * scale;
        ctx.height = this.height * scale; // 计算等比缩小后图片
        ctx.drawImage(this, 0, 0, ctx.width, ctx.height);  // 加载图片
        $(".signAgain").show();
    };
}

function canvasInit () {
    var canvas = document.getElementById("myCanvas")
    canvas.width = document.documentElement.clientWidth;
    canvas.height = document.documentElement.clientHeight - 102;
}

function getImg () {
    return base64Str;
}

function unload () {
    clear()
}

function signClose () {
    $(".startSign").show();
}

</script>
</body>
</html>
