<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp"%>
<html>
<head>
	<title>台账信息管理</title>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8">
	<meta name="decorator" content="ani"/>
	<%@ include file="/webpage/include/bootstraptable.jsp"%>
	<%@include file="/webpage/include/treeview.jsp" %>
	<link rel="stylesheet" href="${ctxStatic}/plugin/layui/dist/css/layui.css">
	<script src="${ctxStatic}/plugin/layui/dist/layui.js"></script>
	<%@include file="ledgerList.js" %>
	<%@include file="../../../include/scan.jsp"  %>
	<script type="text/javascript" src="${ctxStatic}/common/js/big.js"></script>
	<style>
		#scanIpt {
			position: absolute;
			top: -10000px;
			left: 0;
			opacity: 0;
		}
		.scan-content {
			padding: 10px;
		}
	</style>
</head>
<body>
	<div class="wrapper wrapper-content">
	<div class="panel panel-primary">
	<div class="panel-heading">
		<h3 class="panel-title">台账信息列表</h3>
	</div>
	<div class="panel-body">
	
	<!-- 搜索 -->
	<div id="search-collapse" class="collapse show">
		<div class="accordion-inner">
			<form:form id="searchForm" modelAttribute="ledger" class="form form-horizontal well clearfix">
			 <div class="col-xs-12 col-sm-6  col-md-4 col-lg-2">
				<label class="label-item single-overflow  col-md-4 col-lg-4 control-label" title="物资名称：">物资名称：</label>
				 <div class="col-lg-8">
					 <form:input path="name" htmlEscape="false" maxlength="64"  class=" form-control"/>
				 </div>
			</div>
			 <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
				<label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="品名代码：">品名代码：</label>
				 <div class="col-lg-8">
					 <sys:treeselect id="type" name="type.id" value="${ledger.type.id}" labelName="type.name" labelValue="${ledger.type.name}"
									 title="品名代码" url="/warehouse/materialtype/materialType/treeData" extId="${ledger.id}" cssClass="form-control " allowClear="true"/>
				 </div>

			</div>
<%--			 <div class="col-xs-12 col-sm-6 col-md-4">--%>
<%--				<label class="label-item single-overflow pull-left" title="型号：">型号：</label>--%>
<%--				<form:input path="model" htmlEscape="false" maxlength="64"  class=" form-control"/>--%>
<%--			</div>--%>
			 <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
				<label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="货架id集合：">货架id集合：</label>
				 <div class="col-lg-8">
					 <form:input path="shelvesIds" htmlEscape="false" maxlength="64"  class=" form-control"/>
				 </div>

			</div>
			 <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
				<label class="label-item single-overflow col-md-4 col-lg-4 control-label" title="数量：">数量：</label>
				 <div class="col-lg-8">
					 <form:input path="num" htmlEscape="false"  class=" form-control"/>
				 </div>

			</div>
		 <div class="col-xs-12 col-sm-6 col-md-4 col-lg-2">
			<div style="margin-top:0px">
			  <a  id="search" class="btn btn-primary btn-rounded  btn-bordered btn-sm"><i class="fa fa-search"></i> 查询</a>
			  <a  id="reset" class="btn btn-primary btn-rounded  btn-bordered btn-sm" ><i class="fa fa-refresh"></i> 重置</a>
			 </div>
	    </div>	
	</form:form>
	</div>
	</div>
	
	<!-- 工具栏 -->
	<div id="toolbar">
<%--			<shiro:hasPermission name="warehouse:ledger:ledger:add">--%>
<%--				<button id="add" class="btn btn-primary" onclick="add()">--%>
<%--					<i class="glyphicon glyphicon-plus"></i> 新建--%>
<%--				</button>--%>
<%--			</shiro:hasPermission>--%>
<%--			<shiro:hasPermission name="warehouse:ledger:ledger:edit">--%>
<%--			    <button id="edit" class="btn btn-success" disabled onclick="edit()">--%>
<%--	            	<i class="glyphicon glyphicon-edit"></i> 修改--%>
<%--	        	</button>--%>
<%--			</shiro:hasPermission>--%>
<%--			<shiro:hasPermission name="warehouse:ledger:ledger:del">--%>
<%--				<button id="remove" class="btn btn-danger" disabled onclick="deleteAll()">--%>
<%--	            	<i class="glyphicon glyphicon-remove"></i> 删除--%>
<%--	        	</button>--%>
<%--			</shiro:hasPermission>--%>
<%--			<shiro:hasPermission name="warehouse:ledger:ledger:import">--%>
<%--				<button id="btnImport" class="btn btn-info"><i class="fa fa-folder-open-o"></i> 导入</button>--%>
<%--			</shiro:hasPermission>--%>
<%--			<shiro:hasPermission name="warehouse:ledger:ledger:export">--%>
<%--	        		<button id="export" class="btn btn-warning">--%>
<%--					<i class="fa fa-file-excel-o"></i> 导出--%>
<%--				</button>--%>
<%--			 </shiro:hasPermission>--%>
<%--	                 <shiro:hasPermission name="warehouse:ledger:ledger:view">--%>
<%--				<button id="view" class="btn btn-default" disabled onclick="view()">--%>
<%--					<i class="fa fa-search-plus"></i> 查看--%>
<%--				</button>--%>
<%--			</shiro:hasPermission>--%>
		<button class="btn btn-default" onclick="viewScanData()">
			<i class="fa fa-search-plus"></i> 查看二维码数据
		</button>
		<button id="export" class="btn btn-warning">
			<i class="fa fa-file-excel-o"></i> 导出
		</button>
	</div>
		
	<!-- 表格 -->
	<table id="ledgerTable"   data-toolbar="#toolbar"></table>

    <!-- context menu -->
    <ul id="context-menu" class="dropdown-menu">
    	<shiro:hasPermission name="warehouse:ledger:ledger:view">
        <li data-item="view"><a>查看</a></li>
        </shiro:hasPermission>
    	<shiro:hasPermission name="warehouse:ledger:ledger:edit">
        <li data-item="edit"><a>编辑</a></li>
        </shiro:hasPermission>
        <shiro:hasPermission name="warehouse:ledger:ledger:del">
        <li data-item="delete"><a>删除</a></li>
        </shiro:hasPermission>
        <li data-item="action1"><a>取消</a></li>
    </ul>  
	</div>
	</div>
</div>
<script type="type/template" id="scanTpl">
	<div class="scan-content">
		<input type="text" id="scanIpt" />
		<div id="scan-searchForm-box" class="collapse show">
			<div class="accordion-inner">
				<form:form id="scan-searchForm" class="form form-horizontal well clearfix">
					<div class="col-xs-12 col-sm-6 col-md-4">
						<label class="label-item single-overflow pull-left" title="数量：">编号：</label>
<%--						<form:input path="code" htmlEscape="false"  class=" form-control"/>--%>
						<input type="text" id="scan-code" class="form-control" onfocus="scanIptGetFocusStop()" onblur="scanIptGetFocusStart()" />
					</div>
					<div class="col-xs-12 col-sm-6 col-md-4">
						<div style="margin-top:26px">
							<a id="scan-search" class="btn btn-primary btn-rounded  btn-bordered btn-sm" onclick="searchScanData()"><i class="fa fa-search"></i> 查询</a>
							<a id="scan-reset" class="btn btn-primary btn-rounded  btn-bordered btn-sm" onclick="refreshScanData()"><i class="fa fa-refresh"></i> 重置</a>
						</div>
					</div>
				</form:form>
			</div>
		</div>
		<div class="scan-data-content">
			<table id="scan_detail_table"></table>
		</div>
	</div>
</script>

<script type="text/html" id="exportTpl">
	<div id="export-searchForm-box" class="collapse show">
		<div class="accordion-inner">
			<form:form id="export-searchForm" class="form-horizontal">
				<div class="form-group">
					<label class="col-sm-2 control-label">品名：</label>
					<div class="col-sm-10 control-label text-left">
						//<!--<sys:treeselect id="type" name="typeId"
										title="品名代码" url="/warehouse/materialtype/materialType/treeData" notAllowSelectParent="true"
										cssClass="form-control required" allowClear="true" allowSearch="true"/>//-->
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">开始时间：</label>
					<div class="col-sm-10 control-label text-left">
						<input class="form-control required" name="beginTime" id="beginTime"  />
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">结束时间：</label>
					<div class="col-sm-10 control-label text-left">
						<input class="form-control required" name="endTime" id="endTime" />
					</div>
				</div>
			</form:form>
		</div>
	</div>
</script>
</body>
</html>
