<%@ page contentType="text/html;charset=UTF-8" %>
<script>

var errorCode = {
    '0': "成功",
    '-1': '未找到对应的汉王手写设备',
    '-2': '手写模块加载失败',
    '-3': '手写模块初始化失败',
    '-4': '不支持的图片格式',
    '-5': '没有签名数据',
    '-6': '无效输入参数',
    '-10': '有窗口未签字',
    '-11': '请求参数异常',
    '-13': '重复启动签字页面',
    '-14': '请求格式错误',
    '-15': '没有窗口并且者关闭签字设备'
}

var deviceInitParams = {
    "nLogo": "签字",  // 签字界面title
    "nPenwidth": "2",  //  写字宽度  0 - 4
    "nOrgX": "",  // 屏幕x位置
    "nOrgY": "",  // 屏幕y位置
    "width": "500",  // 窗口宽度
    "height": "300",  // 窗口高度
    "fingerFap": "1",  // 指纹模式  0：只签字（默认值）   1:  签字加指纹    （若设备有指纹模块）   2： 只指纹	 （若设备有指纹模块）
    "key": "4A05564228DF2C64AF2E137B71A4E7A3"  // 必须
}

function getLink () {
    return 'http://127.0.0.1:29999';
}

var deviceStartGetSignResultInterval = null;

function getDevice (callback) {
    jp.get(getLink() + '/HWPenSign/HWGetDeviceStatus', function (result) {
        var code = Number(result.msgID);
        if (code === 0) {
            deviceInit();
            callback && callback(true);
        } else {
            logErrMsg(code);
            callback && callback(false);
            clearInterval(deviceStartGetSignResultInterval);
        }
    })
}

function deviceInit () {
    $.ajax({
        type: "get",
        url: getLink() + "/HWPenSign/HWInitialize",
        data: deviceInitParams,
        dataType: "jsonp",
        success: function(result){
            var code = Number(result.msgID);
            if (code === 0) {
                deviceStartGetSignResultInterval = setInterval(function () {
                    getDeviceInputImg();
                }, 2000);
            } else {
                // logErrMsg(data.message);
            }
        },
        error: function(){
            logErrMsg("Application not started");
        }
    });
}

function deviceUninstall () {
    jp.get(getLink() + '/HWPenSign/HWFinalize', function (result) {
        var code = Number(result.msgID);
        if (code === 0) {

        } else {
            logErrMsg(code);
        }
    })
}

function clearDeviceInput () {
    jp.get(getLink() + '/HWPenSign/HWClearPenSign', function (result) {
        var code = Number(result.msgID);
        if (code === 0) {

        } else {
            logErrMsg(code);
        }
    })
}

function getDeviceInputImg () {
    $.ajax({
        type: "get",
        url: getLink() + "/HWPenSign/HWGetSign",
        data: {
            "nImageType": "3",
            "nImageWidth": "",
            "nImageHeight": ""
        },
        dataType: "jsonp",
        success: function(result) {
            var code = Number(result.msgID);
            if (code === 0) {
                clearInterval(deviceStartGetSignResultInterval);
                window.getSignImg && window.getSignImg(result);
            } else if (code === -15) {
                debugger
                clearInterval(deviceStartGetSignResultInterval);
                // logErrMsg(result.msgID);
                signWindowClose();
            } else {
                // logErrMsg(result.msgID);
            }
        },
        error : function(){
            console.log("sign error \n");
        }
    });
}

function clear () {
    clearInterval(deviceStartGetSignResultInterval);
    clearDeviceInput();
    deviceUninstall();
}

function logErrMsg (code) {
    code = code ? code.toString() : '';
    jp.warning(errorCode[code]);
}

function signWindowClose () {
    window.signClose && window.signClose();
}

</script>
