/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.shelves.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;
import com.jeeplus.modules.warehouse.shelves.mapper.ShelvesMapper;

/**
 * 货架信息Service
 * @author zhanglt
 * @version 2023-02-13
 */
@Service
@Transactional(readOnly = true)
public class ShelvesService extends CrudService<ShelvesMapper, Shelves> {

	public Shelves get(String id) {
		return super.get(id);
	}
	
	public List<Shelves> findList(Shelves shelves) {
		return super.findList(shelves);
	}
	
	public Page<Shelves> findPage(Page<Shelves> page, Shelves shelves) {
		return super.findPage(page, shelves);
	}
	
	@Transactional(readOnly = false)
	public void save(Shelves shelves) {
		super.save(shelves);
	}
	
	@Transactional(readOnly = false)
	public void delete(Shelves shelves) {
		super.delete(shelves);
	}
	
}