<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<!-- _login_page_ --><!--登录超时标记 勿删-->
<html>

<head>
    <meta name="decorator" content="ani"/>
    <title>${fns:getConfig('productName')} 登录</title>
    <link rel="stylesheet" href="${ctxStatic}/common/css/login.css">
    <script>
        if (window.top !== window.self) {
            window.top.location = window.location;
        }
    </script>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#loginForm").validate({
                rules: {
                    validateCode: {remote: "${pageContext.request.contextPath}/servlet/validateCodeServlet"}
                },
                messages: {
                    username: {required: "请填写用户名."}, password: {required: "请填写密码."},
                    validateCode: {remote: "验证码不正确.", required: "请填写验证码."}
                },
                errorLabelContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    error.appendTo($("#loginError").parent());
                }
            });
        });
        // 如果在框架或在对话框中，则弹出提示并跳转到首页
        if (self.frameElement && self.frameElement.tagName == "IFRAME" || $('#left').length > 0) {
            alert('未登录或登录超时。请重新登录，谢谢！');
            top.location = "${ctx}";
        }
    </script>

</head>


<body>


<div class="login-page">
            <sys:message content="${message}" showType="1"/>
            <form id="loginForm" role="form" action="${ctx}/login" method="post">
                <div><img class="logo" src="${ctxStatic}/common/images/logo.png"></div>
                <div class="title">${fns:getConfig('productName')}</div>
                <div class="form-content">
                    <div class="form-group">
                        <input type="text" id="username" name="username"
                               class="form-control input-text input-lg required" value="admin"
                               placeholder="用户名">
                    </div>

                    <div class="form-group">
                        <input type="password" id="password" name="password" value="admin"
                               class="form-control input-text input-lg required" placeholder="密码">
                    </div>
                    <c:if test="${isValidateCodeLogin}">
                        <div class="form-group  text-muted">
                            <label class="inline">验证码:</label>
                            <sys:validateCode name="validateCode" inputCssStyle="margin-bottom:5px;"
                                              buttonCssStyle="color:white"/>
                        </div>
                    </c:if>
                </div>
                <input type="submit" class="btn btn-primary input-text btn-lg  progress-login" value="登录">
                &nbsp;
            </form>
</div>

<script>


    $(function () {
        $('.theme-picker').click(function () {
            changeTheme($(this).attr('data-theme'));
        });

    });

    function changeTheme(theme) {
        $('<link>')
            .appendTo('head')
            .attr({type: 'text/css', rel: 'stylesheet'})
            .attr('href', '${ctxStatic}/common/css/app-' + theme + '.css');
        //$.get('api/change-theme?theme='+theme);
        $.get('${pageContext.request.contextPath}/theme/' + theme + '?url=' + window.top.location.href, function (result) {
        });
    }
</script>
</body>
</html>