<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>盘盈入库单管理</title>
    <meta name="decorator" content="ani"/>
    <link rel="stylesheet" href="${ctxStatic}/common/css/form.css">
    <link rel="stylesheet" href="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.css">
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.js"></script>
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table-zh-CN.js"></script>
    <script type="text/javascript" src="${ctxStatic}/common/js/big.js"></script>
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-body">
                    <form:form id="inputForm" modelAttribute="profitWarehousing"
                               action="${ctx}/warehouse/profitwarehousing/profitWarehousing/save" method="post"
                               class="form-horizontal">
                        <form:hidden path="id"/>
                        <h3 class="text-center">盘盈入库单</h3>
                        <table class="table table-bordered main-table">
                            <tr>
                                <td> <font color="red">*</font>单号</td>
                                <td>
                                    <form:input path="number" htmlEscape="false" readonly="true" class="form-control required"/>
                                </td>
                                <td><font color="red">*</font>操作人</td>
                                <td>
                                    <sys:userselect id="operator" name="operator.id" value="${profitWarehousing.operator.id}"
                                                    labelName="operator.name" labelValue="${profitWarehousing.operator.name}"
                                                    cssClass="form-control required" disabled="disabled"/>
                                </td>
                            </tr>
                            <tr>
                                <td><font color="red">*</font>时间</td>
                                <td>
                                    <div class='input-group form_datetime' id='time'>
                                        <input type='text' name="time" class="form-control required" autocomplete="off"
                                               value="<fmt:formatDate value="${profitWarehousing.time}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
                                        <span class="input-group-addon">
								<span class="glyphicon glyphicon-calendar"></span>
							</span>
                                    </div>
                                </td>
                                <td>
                                    总价
                                </td>
                                <td>
                                    <form:input path="sum" htmlEscape="false" readonly="true" cssClass="form-control"/>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    备注
                                </td>
                                <td colspan="3">
                                    <form:textarea path="remarks" htmlEscape="false" rows="4" class="form-control "/>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <%@ include file="profitWarehousingDetail.jsp"%>
                                </td>
                            </tr>
                        </table>
                    </form:form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">

    $(document).ready(function () {
        initTable();
        $('#time').datetimepicker({
            format: "YYYY-MM-DD HH:mm:ss"
        });
    });
    function save() {
        var isValidate = jp.validateForm('#inputForm');//校验表单
        if(!isValidate){
            return false;
        }else{
            var hasDetails = getTableData().length == 0;
            if(hasDetails){
                jp.warning('请填写明细!');
                return;
            }
            jp.loading();
            jp.post($("#inputForm").attr('action'),$('#inputForm').serialize(),function(data){
                if(data.success){
                    jp.getParent().refresh();
                    var dialogIndex = parent.layer.getFrameIndex(window.name); // 获取窗口索引
                    parent.layer.close(dialogIndex);
                    jp.success(data.msg)

                }else{
                    jp.error(data.msg);
                }
            })
        }

    }
</script>
</body>
</html>