<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>物资领用管理</title>
    <meta name="decorator" content="ani"/>
    <link rel="stylesheet" href="${ctxStatic}/common/css/form.css">
    <link rel="stylesheet" href="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.css">
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.js"></script>
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table-zh-CN.js"></script>
    <style>
        .sign-result{
            width: 80px;
            position: relative;
        }
        .sign-result .del-sign{
            position: absolute;
            top: -8px;
            right: -7px;
            width: 16px;
            height: 16px;
            line-height: 16px;
            background: #f00;
            text-align: center;
            border-radius: 100%;
            color: #fff;
            cursor: pointer;
        }
        .sign:focus-visible {
            outline: none;
        }
    </style>
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-body">
                    <form:form id="inputForm" modelAttribute="materialRequisition"
                               action="${ctx}/warehouse/materialrequisition/materialRequisition/save" method="post"
                               class="form-horizontal">
                        <form:hidden path="id"/>
                        <h3 class="text-center">物资领用表</h3>
                        <table class="table table-bordered main-table">
                            <tr>
                                <td> <font color="red">*</font>领用单号</td>
                                <td>
                                    <form:input path="number" htmlEscape="false" readonly="true" class="form-control required"/>
                                </td>
                                <td><font color="red">*</font>操作人</td>
                                <td>
                                    <sys:userselect id="operator" name="operator.id"
                                                    value="${materialRequisition.operator.id}" labelName="operator.name"
                                                    labelValue="${materialRequisition.operator.name}" disabled="disabled"
                                                    cssClass="form-control required"/>
                                </td>
                            </tr>
                            <tr>
                                <td><font color="red">*</font>领用机构</td>
                                <td>
                                    <sys:treeselect id="office" name="office.id" value="${materialRequisition.office.id}"
                                                    labelName="" labelValue="${materialRequisition.office.name}"
                                                    title="部门" url="/sys/office/treeData?type=2" cssClass="form-control required"
                                                    allowClear="true" notAllowSelectParent="true"/>
                                </td>
                                <td><font color="red">*</font>领用时间</td>
                                <td>
                                    <div class='input-group form_datetime' id='time'>
                                        <input type='text' name="time" class="form-control required"
                                               value="<fmt:formatDate value="${materialRequisition.time}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
                                        <span class="input-group-addon">
								        <span class="glyphicon glyphicon-calendar"></span>
                                    </span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td>备注</td>
                                <td colspan="3">
                                    <form:textarea path="remarks" htmlEscape="false" rows="4" class="form-control "/>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <%@include file="materialRequisitionDetail.jsp" %>
                                </td>
                            </tr>
                        </table>
                    </form:form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">

    $(document).ready(function() {
        initTable();
        jp.ajaxForm("#inputForm",function(data){
            if(data.success){
                jp.success(data.msg);
                jp.go("${ctx}/warehouse/materialrequisition/materialRequisition");
            }else{
                jp.error(data.msg);
                $("#inputForm").find("button:submit").button("reset");
            }
        });

        $('#time').datetimepicker({
            format: "YYYY-MM-DD HH:mm:ss"
        });
    });

    function save() {
        var isValidate = jp.validateForm('#inputForm');//校验表单
        if(!isValidate){
            return false;
        }else{
            var hasDetails = getTableData().length == 0;
            if(hasDetails){
                jp.warning('请填写领用物资!');
                return;
            }
            var hasReceiver = getTableData().every(function(item){
                return item.receiver
            })
            // if(!hasReceiver){
            //     jp.warning('领用人必填!');
            //     return;
            // }
            jp.loading();
            jp.post($("#inputForm").attr('action'),$('#inputForm').serialize(),function(data){
                if(data.success){
                    jp.getParent().refresh();
                    var dialogIndex = parent.layer.getFrameIndex(window.name); // 获取窗口索引
                    parent.layer.close(dialogIndex);
                    jp.success(data.msg)

                }else{
                    jp.error(data.msg);
                }
            })
        }

    }
</script>
</body>
</html>