/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.wzcode.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.modules.warehouse.wzcode.entity.Wzcode;
import com.jeeplus.modules.warehouse.wzcode.mapper.WzcodeMapper;

/**
 * 物资编码模块Service
 * @author 胡懿
 * @version 2023-02-24
 */
@Service
@Transactional(readOnly = true)
public class WzcodeService extends CrudService<WzcodeMapper, Wzcode> {

	public Wzcode get(String id) {
		return super.get(id);
	}
	
	public List<Wzcode> findList(Wzcode wzcode) {
		return super.findList(wzcode);
	}
	
	public Page<Wzcode> findPage(Page<Wzcode> page, Wzcode wzcode) {
		return super.findPage(page, wzcode);
	}
	
	@Transactional(readOnly = false)
	public void save(Wzcode wzcode) {
		super.save(wzcode);
	}
	
	@Transactional(readOnly = false)
	public void delete(Wzcode wzcode) {
		super.delete(wzcode);
	}

	public Wzcode findByCode(String code) {
		Wzcode tem = new Wzcode();
		tem.setCode(code);
		Wzcode wzcode = mapper.findByCode(tem);
		if (null != wzcode) {
			return wzcode;
		} else {
			tem.setIntNum(0);
			return tem;
		}
	}

	public static void main(String[] args) {
		Wzcode tem = new Wzcode();
		tem.setIntNum(123);
		System.out.println(tem.getNum());
	}
}