/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.ledger.mapper;

import com.jeeplus.core.persistence.BaseMapper;
import com.jeeplus.core.persistence.annotation.MyBatisMapper;
import com.jeeplus.modules.warehouse.ledger.dto.CountLedgerInfo;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 台账明细MAPPER接口
 * @author huyi
 * @version 2023-02-13
 */
@MyBatisMapper
public interface LedgerInfoMapper extends BaseMapper<LedgerInfo> {

    public List<CountLedgerInfo> findCliList(LedgerInfo ledgerInfo);
    void deleteByLedgerInfo(@Param("id") String id);
    public List<LedgerInfo> findListByQrIdAndCode(LedgerInfo ledgerInfo);
    void updateByLedgerInfo(@Param("id") String id);
}