<%--
  Created by IntelliJ IDEA.
  User: yangzi
  Date: 2023/2/21
  Time: 10:29
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<table id="detail_table"></table>
<script>
    var selector = "#detail_table";

    function initTable() {
        var data = [];
        $(selector).bootstrapTable({
            data: data,
            columns: [
                {
                    field: 'no',
                    title: '序号',
                    align: 'center',
                    width: 60,
                    formatter: function (value, row, index) {
                        return '<span>' + (index + 1) + '</span>'
                    }
                },
                {
                    field: 'type.name',
                    title: '品名代码',
                    align: 'center'
                },
                {
                    field: 'model',
                    title: '型号',
                    align: 'center'
                },
                {
                    field: 'batchNum',
                    title: '批次号',
                    align: 'center'
                },
                {
                    field: 'shelvesNames',
                    title: '货架',
                    align: 'center'
                },
                {
                    field: 'warehouseNames',
                    title: '仓库',
                    align: 'center'
                },
                {
                    title: '操作',
                    align: 'center',
                    formatter: function (){
                        return '<a class="view-detail">查看明细</a>'
                    },
                    events: {
                       'click .view-detail': function (e,value,row){
                            layer.open({
                                title: '查看明细',
                                type: 1,
                                auto: true,
                                area: ['800', '600'],
                                content: $("#detailTpl").html(),
                                success: function (){
                                    $("#table").bootstrapTable({
                                        method: 'get',
                                        url: '${ctx}/warehouse/ledger/ledger/infoDate?batchNum='+ row.batchNum+'&ledger.id=${ledger.id}',
                                        page: true,
                                        columns: [
                                            {field: 'name', title: '物资名称'},
                                            {field: 'type.name', title: '品名代码'},
                                            {field: 'model', title: '型号'},
                                            {field: 'batchNum', title: '批次号'},
                                            {field: 'shelves.name', title: '货架'},
                                            {field: 'code', title: '物资编码'},
                                            {field: 'amount', title: '单价'},
                                        ]
                                    })
                                },
                            })
                        }
                    }
                }
            ]
        });

        jp.get("${ctx}/warehouse/ledger/ledger/countLedger?id=${ledger.id}", function (ledger) {
            var data = ledger.countLedgerInfoList || [];
            $(selector).bootstrapTable('append', data);
        })
    }

    function getSelections() {
        return $(selector).bootstrapTable('getSelections');
    }

    function removeRow(index, rowId, rowDelFlag) {
        if (rowId) {
            var delFlag = rowDelFlag === 1 ? 0 : 1
            updateRow(index, {
                delFlag: delFlag
            })
        } else {
            $(selector).bootstrapTable("remove", {
                field: '$index',
                values: [index]
            })
        }
    }

    function updateRow(index, row) {
        $(selector).bootstrapTable('updateRow', {
            index: index,
            row: row
        })
    }

    function onInputChange(rowIndex, elem, field) {
        var obj = {};
        obj[field] = $(elem).val()
        var timer = null;
        clearTimeout(timer);
        timer = setTimeout(function () {
            updateRow(rowIndex, obj)
        }, 0)
    }

    function onSelectType(nodes, rowIndex) {
        if (Array.isArray(nodes) && nodes.length === 1) {
            var node = nodes[0];
            var obj = {
                type: {
                    id: node.id,
                    name: node.text
                }
            };
            updateRow(rowIndex, obj)
        }
    }

    /**
     * 获取所有明细数据
     * @returns {*|jQuery}
     */
    function getTableData() {
        return $(selector).bootstrapTable('getData');
    }
</script>

<script id="detailTpl" type="text/html">
    <br>
    <div class="container-fluid">
        <table id="table"></table>
    </div>
</script>