<%--
  Created by IntelliJ IDEA.
  User: yangzi
  Date: 2023/2/21
  Time: 10:29
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<div id="toolbar" class="text-left">
  <c:if test="${mode == 'add' || mode == 'edit'}">
    <a class="btn btn-primary btn-sm" onclick="addDetail('#detail_table')" title="新增"><i class="fa fa-plus"></i> 手动添加</a>
    <a class="btn btn-primary btn-sm" onclick="addScan('#detail_table')" title="新增"><i class="fa fa-plus"></i> 扫码添加</a>
    <a id="editAll" class="btn btn-primary btn-sm"  onclick="addShelve('#detail_table')" title="新增"><i class="fa fa-plus"></i> 批量编辑货架</a>
  </c:if>
</div>
<table id="detail_table" data-toolbar="#toolbar"></table>
<script>
  var selector = "#detail_table";
  function initTable(){
    var data = ${fns:toJson(materialRequisition.materialRequisitionInfoList)};
    $(selector).bootstrapTable({
      data: data,
      columns:[{checkbox: true},
        {
          field: 'no',
          title: '序号',
          align: 'center',
          width: 60,
          formatter: function (value, row, index){
            var tpl = $("#hideTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, "");
            var html = Mustache.render(tpl, {
              idx: index,
              row: row
            })

            return html + '<span>'+(index+1)+'</span>'
          }
        },
        {
          field: 'name',
          title: '名称',
          formatter: function (value,row,index){
            return Mustache.render($("#nameTpl").html(),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'type.name',
          title: '类型',
          formatter: function (value,row,index){
            return Mustache.render($("#typeTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'remarks',
          title: '备注',
          formatter: function (value,row,index){
            return Mustache.render($("#remarksTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: '',
          title: '操作',
          formatter: function (value,row,index){
            var text = row.delFlag == 1 ? '撤销删除' : '删除';
            var result = ["<a href='javascript:void(0);' onclick=\"removeRow(" + index + ", '" + row.id + "',  '" + row.delFlag + "')\">"+text+"</a>" ]
            return result.join('');
          }
        }
      ]
    });
    $(selector).on('check.bs.table uncheck.bs.table load-success.bs.table ' +
            'check-all.bs.table uncheck-all.bs.table', function () {
      $('#editAll').prop('disabled', !getSelections().length);
    });
  }

  function getSelections(){
    return $(selector).bootstrapTable('getSelections');
  }

  /**
   * 手动添加明细
   * @param selector
   */
  function addDetail(selector){
    // 选择该批次号下的货品明细
    if(!$("#batchNum").val()){
      jp.warning('请选择批次号！');
      return;
    }

    jp.openStorageSelectDialog({batchNum:$("#batchNum").val(),state: 0, isMultiSelect: true },function (items){
      if(Array.isArray(items)){
        var data = items.map(function (item){
          if(item.goodsInfo && !item.goodsInfo.amount){
            item.goodsInfo.amount = 0;
          }
          return {
            id: '',
            delFlag: 0,
            remarks: '',
            ...item
          }
        })
        $(selector).bootstrapTable('append', data)
      }
    })


  }
  function removeRow(index, rowId, rowDelFlag){
    if(rowId){
      var delFlag = rowDelFlag === 1 ? 0 : 1
      updateRow(index, {
        delFlag: delFlag
      })
    }else{
      $(selector).bootstrapTable("remove", {
        field: '$index',
        values: [index]
      })
    }
  }
  function updateRow(index, row){
    $(selector).bootstrapTable('updateRow', {
      index: index,
      row: row
    })
  }
  function onInputChange(rowIndex, elem , field){
    var obj = {};
    obj[field] = $(elem).val()
    var timer = null;
    clearTimeout(timer);
    timer = setTimeout(function (){
      updateRow(rowIndex, obj)
    }, 0)
  }

  function onSelectType(nodes, rowIndex){
    if(Array.isArray(nodes) && nodes.length === 1){
      var node = nodes[0];
      var obj = {
        type: {
          id: node.id,
          name: node.text
        }
      };
      updateRow(rowIndex, obj)
    }
  }

  /**
   * 获取所有明细数据
   * @returns {*|jQuery}
   */
  function getTableData(){
    return $(selector).bootstrapTable('getData');
  }

  function addShelve(){
    jp.openShelvesSelectDialog(function (items){
      var Shelve = items[0];
      // TODO: 获取选中的明细下标
      getSelections().forEach(function (item){
        var index = getTableData().findIndex(function (current){
          return current.qrCode.id === item.qrCode.id;
        })
        updateRow(index,{
          shelves: {
            id: Shelve.id,
            name: Shelve.name
          },
          warehouse: Shelve.warehouse
        })
      })

    })
  }

  /**
   * 点击扫码显示扫码窗口
   */
  function addScan(){
    layer.open({
      type: 1,
      title: '扫码',
      auto: true,
      area: ['500','300'],
      content: $("#scanResultTpl").html(),
      success: function (){
        $("#scanResult").focus();
      },
      btn:['关闭']
    })
  }

  /**
   * 扫码
   * 一、获取扫码结果
   * 二、请求后台接口获取结果
   * 三、增一条明细数据
   * 四、清空扫码结果
   * @param elem
   */
  function onScanChange(elem){
    try{
      var json = JSON.parse($(elem).val());
      var qrCodeId = json.code;
      var goodsInfoId = json.infoId;
      jp.get('${ctx}/warehouse/goods/goods/getGIAndQCByTwoId?goodsInfoId='+goodsInfoId+"&qrCodeId="+qrCodeId, function (res){
        var qrCode = res.body.qrCode;
        $(selector).bootstrapTable('append',[
          {
            qrCode: qrCode,
            goodsInfo: qrCode.goodsInfo,
            ...qrCode.goodsInfo,
            id: '',
            delFlag: 0,
            remarks: ''
          }
        ]);
        $(elem).val('').focus();
      })

    }catch (e){
      console.log(e);
    }
  }
</script>

<script id="hideTpl" type="text/html">
  <input id="materialRequisitionInfoList{{idx}}_id" name="materialRequisitionInfoList[{{idx}}].id" type="hidden" value="{{row.id}}"/>
  <input id="materialRequisitionInfoList{{idx}}_delFlag" name="materialRequisitionInfoList[{{idx}}].delFlag" type="hidden" value="{{row.delFlag}}"/>
  <input id="materialRequisitionInfoList{{idx}}_materialRequisition" name="materialRequisitionInfoList[{{idx}}].materialRequisition.id" type="hidden" value="{{row.materialRequisition.id}}"/>
</script>

<script id="ledgerInfoTpl" type="text/html">//<!--
  <sys:gridselect url="${ctx}/warehouse/ledger/ledger/data" id="materialRequisitionInfoList{{idx}}_ledgerInfo" name="materialRequisitionInfoList[{{idx}}].ledgerInfo.id" value="{{row.ledgerInfo.id}}" labelName="materialRequisitionInfoList[{{idx}}].ledgerInfo.name" labelValue="{{row.ledgerInfo.name}}"
                  title="选择物资" cssClass="form-control required" fieldLabels="物资名称|物资编号" fieldKeys="name|code" searchLabels="仓库名称|仓库编号" searchKeys="name|code" ></sys:gridselect>//-->
</script>

<script id="typeTpl" type="text/html">//<!--
    <sys:treeselect id="storageInfoList{{idx}}_type" name="storageInfoList[{{idx}}].type.id" value="{{row.type.id}}" labelName="storageInfoList{{idx}}.type.name" labelValue="{{row.type.name}}"
							title="类型" url="/warehouse/materialtype/materialType/treeData" cssClass="form-control  " disabled="disabled" allowClear="true" allowSearch="true" callback="onSelectType" />//-->
</script>

<script id="modelTpl" type="text/html">
  <input id="storageInfoList{{idx}}_model" name="storageInfoList[{{idx}}].model" type="text" value="{{row.model}}" readonly onchange="onInputChange('{{idx}}', this, 'model')"    class="form-control "/>
</script>
<script id="shelvesTpl" type="text/html">
  <input id="storageInfoList{{idx}}_shelvesName" name="storageInfoList[{{idx}}].shelves.name" type="text" value="{{row.shelves.name}}"  readonly class="form-control" />
</script>
<script id="remarksTpl" type="text/html">
  <textarea id="storageInfoList{{idx}}_remarks" name="storageInfoList[{{idx}}].remarks" rows="2"  onchange="onInputChange('{{idx}}', this, 'remarks')"  class="form-control ">{{row.remarks}}</textarea>
</script>

<script id="scanResultTpl" type="text/html">
  <br>
  <div class="container-fluid">
    <div class="row">
      <div class="col-xs-2 text-right">
        <label>扫码结果:</label>
      </div>
      <div class="col-xs-10">
        <input type="text" id="scanResult" class="form-control" onchange="onScanChange(this)">
        <span class="text-danger">请切换英文输入法</span>
      </div>
    </div>
  </div>
  <br>
</script>