<%--
  Created by IntelliJ IDEA.
  User: yangzi
  Date: 2023/2/21
  Time: 10:29
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<table id="detail_table"></table>
<script>
  var selector = "#detail_table";
  function initTable(){
    var data = ${fns:toJson(ledger.ledgerInfoList)};
    $(selector).bootstrapTable({
      data: data,
      columns:[
        {
          field: 'no',
          title: '序号',
          align: 'center',
          width: 60,
          formatter: function (value, row, index){
            var tpl = $("#hideTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, "");
            var html = Mustache.render(tpl, {
              idx: index,
              row: row
            })

            return html + '<span>'+(index+1)+'</span>'
          }
        },
        {
          field: 'name',
          title: '名称',
          formatter: function (value,row,index){
            return Mustache.render($("#nameTpl").html(),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'type.name',
          title: '类型',
          formatter: function (value,row,index){
            return Mustache.render($("#typeTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'model',
          title: '型号',
          formatter: function (value,row,index){
            return Mustache.render($("#modelTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'batchNum',
          title: '批次号',
          formatter: function (value,row,index){
            return Mustache.render($("#batchNumTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'shelves.name',
          title: '货架',
          formatter: function (value,row,index){
            return Mustache.render($("#shelvesTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'code',
          title: '物资编码',
          formatter: function (value,row,index){
            return Mustache.render($("#codeTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: '',
          title: '操作',
          formatter: function (value,row,index){
            var text = row.delFlag == 1 ? '撤销删除' : '删除';
            var result = ["<a href='javascript:void(0);' onclick=\"removeRow(" + index + ", '" + row.id + "',  '" + row.delFlag + "')\">"+text+"</a>" ]
            return result.join('');
          }
        }
      ]
    });
  }

  function getSelections(){
    return $(selector).bootstrapTable('getSelections');
  }

  function removeRow(index, rowId, rowDelFlag){
    if(rowId){
      var delFlag = rowDelFlag === 1 ? 0 : 1
      updateRow(index, {
        delFlag: delFlag
      })
    }else{
      $(selector).bootstrapTable("remove", {
        field: '$index',
        values: [index]
      })
    }
  }
  function updateRow(index, row){
    $(selector).bootstrapTable('updateRow', {
      index: index,
      row: row
    })
  }
  function onInputChange(rowIndex, elem , field){
    var obj = {};
    obj[field] = $(elem).val()
    var timer = null;
    clearTimeout(timer);
    timer = setTimeout(function (){
      updateRow(rowIndex, obj)
    }, 0)
  }

  function onSelectType(nodes, rowIndex){
    if(Array.isArray(nodes) && nodes.length === 1){
      var node = nodes[0];
      var obj = {
        type: {
          id: node.id,
          name: node.text
        }
      };
      updateRow(rowIndex, obj)
    }
  }

  /**
   * 获取所有明细数据
   * @returns {*|jQuery}
   */
  function getTableData(){
    return $(selector).bootstrapTable('getData');
  }
</script>

<script id="hideTpl" type="text/html">
  <input id="ledgerInfoList{{idx}}_id" name="ledgerInfoList[{{idx}}].id" type="hidden" value="{{row.id}}"/>
  <input id="ledgerInfoList{{idx}}_delFlag" name="ledgerInfoList[{{idx}}].delFlag" type="hidden" value="{{row.delFlag}}"/>
  <input id="ledgerInfoList{{idx}}_goodsInfoId" name="ledgerInfoList[{{idx}}].goodsInfo.id" type="hidden" value="{{row.goodsInfo.id}}"/>
  <input id="ledgerInfoList{{idx}}_shelvesId" name="ledgerInfoList[{{idx}}].shelves.id" type="hidden" value="{{row.shelves.id}}" readonly class="form-control" />
  <input id="ledgerInfoList{{idx}}_qrCodeId" name="ledgerInfoList[{{idx}}].qr.id" type="hidden" value="{{row.qr.id}}" readonly class="form-control" />
</script>

<script id="nameTpl" type="text/html">
  <input id="ledgerInfoList{{idx}}_name" name="ledgerInfoList[{{idx}}].name" type="text" readonly value="{{row.name}}" onchange="onInputChange('{{idx}}', this, 'name')"   class="form-control "/>
</script>

<script id="typeTpl" type="text/html">//<!--
    <sys:treeselect id="ledgerInfoList{{idx}}_type" name="ledgerInfoList[{{idx}}].type.id" value="{{row.type.id}}" labelName="storageInfoList{{idx}}.type.name" labelValue="{{row.type.name}}"
							title="类型" url="/warehouse/materialtype/materialType/treeData" cssClass="form-control  " disabled="disabled" allowClear="true" allowSearch="true" callback="onSelectType" />//-->
</script>

<script id="modelTpl" type="text/html">
  <input id="ledgerInfoList{{idx}}_model" name="ledgerInfoList[{{idx}}].model" type="text" value="{{row.model}}" readonly onchange="onInputChange('{{idx}}', this, 'model')"    class="form-control "/>
</script>

<script id="batchNumTpl" type="text/html">
  <input id="ledgerInfoList{{idx}}_batchNum" name="ledgerInfoList[{{idx}}].batchNum" type="text" value="{{row.batchNum}}" readonly onchange="onInputChange('{{idx}}', this, 'model')"    class="form-control "/>
</script>

<script id="shelvesTpl" type="text/html">
  <input id="ledgerInfoList{{idx}}_shelvesName" name="ledgerInfoList[{{idx}}].shelves.name" type="text" value="{{row.shelves.name}}" readonly onchange="onInputChange('{{idx}}', this, 'model')"    class="form-control "/>
</script>

<script id="codeTpl" type="text/html">
  <input id="ledgerInfoList{{idx}}_code" name="ledgerInfoList[{{idx}}].code" type="text" value="{{row.code}}"  readonly class="form-control" />
</script>
