/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.profitwarehousing.service;

import java.math.BigDecimal;
import java.util.List;

import com.jeeplus.modules.warehouse.code.util.CodeUtil;
import com.jeeplus.modules.warehouse.code.util.StaticNumSeq;
import com.jeeplus.modules.warehouse.ledger.entity.Ledger;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;
import com.jeeplus.modules.warehouse.ledger.mapper.LedgerMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.profitwarehousing.entity.ProfitWarehousing;
import com.jeeplus.modules.warehouse.profitwarehousing.mapper.ProfitWarehousingMapper;
import com.jeeplus.modules.warehouse.profitwarehousing.entity.ProfitWarehousingInfo;
import com.jeeplus.modules.warehouse.profitwarehousing.mapper.ProfitWarehousingInfoMapper;

/**
 * 盘盈入库单Service
 * @author zhanglt
 * @version 2023-02-14
 */
@Service
@Transactional(readOnly = true)
public class ProfitWarehousingService extends CrudService<ProfitWarehousingMapper, ProfitWarehousing> {

	@Autowired
	private ProfitWarehousingInfoMapper profitWarehousingInfoMapper;
	@Autowired
	private LedgerMapper ledgerMapper;

	public ProfitWarehousing get(String id) {
		ProfitWarehousing profitWarehousing = super.get(id);
		profitWarehousing.setProfitWarehousingInfoList(profitWarehousingInfoMapper.findList(new ProfitWarehousingInfo(profitWarehousing)));
		return profitWarehousing;
	}
	
	public List<ProfitWarehousing> findList(ProfitWarehousing profitWarehousing) {
		return super.findList(profitWarehousing);
	}
	
	public Page<ProfitWarehousing> findPage(Page<ProfitWarehousing> page, ProfitWarehousing profitWarehousing) {
		return super.findPage(page, profitWarehousing);
	}
	@Transactional(readOnly = false)
	public String createPYDH() {
		String pydh = CodeUtil.code("PYDH", StaticNumSeq.PYDH);
		return pydh;
	}
	@Transactional(readOnly = false)
	public void save(ProfitWarehousing profitWarehousing) {
		profitWarehousing.setNumber(createPYDH());
		super.save(profitWarehousing);
		for (ProfitWarehousingInfo profitWarehousingInfo : profitWarehousing.getProfitWarehousingInfoList()){
			profitWarehousingInfo.setProfitWarehousing(profitWarehousing);
			if (profitWarehousingInfo.getId() == null){
				continue;
			}
			if (ProfitWarehousingInfo.DEL_FLAG_NORMAL.equals(profitWarehousingInfo.getDelFlag())){
				if (StringUtils.isBlank(profitWarehousingInfo.getId())){
					profitWarehousingInfo.preInsert();
					profitWarehousingInfoMapper.insert(profitWarehousingInfo);
				}else{
					profitWarehousingInfo.preUpdate();
					profitWarehousingInfoMapper.update(profitWarehousingInfo);
				}
			}else{
				profitWarehousingInfoMapper.delete(profitWarehousingInfo);
			}
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(ProfitWarehousing profitWarehousing) {
		super.delete(profitWarehousing);
		profitWarehousingInfoMapper.delete(new ProfitWarehousingInfo(profitWarehousing));
	}
	//盘盈入库 保存 盘盈入库信息 ，并添加对应的台账信息
	@Transactional(readOnly = false)
	public void inLedgerInfo(ProfitWarehousing profitWarehousing) {
		List<ProfitWarehousingInfo> profitWarehousingInfoList = profitWarehousing.getProfitWarehousingInfoList();
		//当前盘盈入库单的明细信息
		BigDecimal sum = BigDecimal.ONE;
		if(profitWarehousingInfoList != null ){
			if(profitWarehousingInfoList.size() > 0 ){
				for (ProfitWarehousingInfo one:profitWarehousingInfoList) {
					BigDecimal amount = one.getAmount();
					if(amount != null){
						//总价 是所有单价之和
						sum = sum.add(amount);
					}
					//获取同名称类型型号的台账主表信息
					Ledger ledger = new Ledger(one.getName(),one.getType(),one.getMarking());
					Ledger oldLeger = ledgerMapper.findByTypeAndModel(ledger);
					if(oldLeger!=null){
						LedgerInfo ledgerInfo = new LedgerInfo();
						ledgerInfo.setLedger(oldLeger);
						ledgerInfo.setAmount(one.getAmount());
					}
				}	
			}
		}
	}
}