/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.code.service;

import com.jeeplus.common.utils.DateUtils;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.modules.warehouse.code.entity.NumSeq;
import com.jeeplus.modules.warehouse.code.mapper.NumSeqMapper;
import com.jeeplus.modules.warehouse.code.util.StaticNumSeq;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * 编码序列Service
 * @author admin
 * @version 2021-09-06
 */
@Service
@Transactional(readOnly = true)
public class NumSeqService extends CrudService<NumSeqMapper, NumSeq> {

    public NumSeq get(String id) {
        return super.get(id);
    }

    public List<NumSeq> findList(NumSeq numSeq) {
        return super.findList(numSeq);
    }

    public Page<NumSeq> findPage(Page<NumSeq> page, NumSeq numSeq) {
        return super.findPage(page, numSeq);
    }

    @Transactional(readOnly = false)
    public void save(NumSeq numSeq) {
        super.save(numSeq);
    }

    @Transactional(readOnly = false)
    public void delete(NumSeq numSeq) {
        super.delete(numSeq);
    }

    @Transactional(readOnly = false)
    public Integer getNumSeq(String module){
        if(StringUtils.isEmpty(module)){
            throw new RuntimeException("module传参不能为空");
        }
        if (!StaticNumSeq.seqList().contains(module)){
            throw new RuntimeException("module传参错误,请查询StaticNumSeq类型中的常量进行传参");
        }
        Integer seq = null;
        String month = DateUtils.getMonth();

        NumSeq numSeq = mapper.getbyModule(module);
        if(numSeq == null){
            numSeq = new NumSeq();
            numSeq.setModule(module);
            numSeq.setMonth(month);
            numSeq.setSeq(2);
            numSeq.preInsert();
            mapper.insert(numSeq);
            seq = 1;
        }else{
            if(!month.equals(numSeq.getMonth())){
                numSeq.setMonth(month);
                numSeq.setSeq(2);
                numSeq.preUpdate();
                mapper.update(numSeq);
                seq = 1;
            }else{
                seq = numSeq.getSeq();
                numSeq.setSeq(seq+1);
                mapper.update(numSeq);
            }
        }
        return seq;
    }
    @Transactional(readOnly = false)
    public void initNumSeq(){
        List<NumSeq> numSeqList = mapper.findList(new NumSeq());

        List<String> tempNumSeq = new ArrayList<>();
        for(String str : StaticNumSeq.seqList()){
            tempNumSeq.add(new String(str));
        }
        Iterator<String> stringIterator = tempNumSeq.iterator();
        while(stringIterator.hasNext()){
            String str = stringIterator.next();
            for(NumSeq numSeq : numSeqList){
                if(numSeq.getModule().equals(str))
                    stringIterator.remove();
            }
        }
        numSeqList = new ArrayList<>();
        for (String str : tempNumSeq){
            NumSeq numSeq = new NumSeq();
            numSeq.setMonth(DateUtils.getMonth());
            numSeq.setModule(str);
            numSeq.setSeq(1);
            numSeq.preInsert();
            mapper.insert(numSeq);
        }
    }
}