/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialloss.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import com.jeeplus.modules.warehouse.code.util.CodeUtil;
import com.jeeplus.modules.warehouse.code.util.StaticNumSeq;
import com.jeeplus.modules.warehouse.ledger.entity.Ledger;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;
import com.jeeplus.modules.warehouse.ledger.mapper.LedgerInfoMapper;
import com.jeeplus.modules.warehouse.ledger.service.LedgerService;
import com.jeeplus.modules.warehouse.materialrequisition.entity.MaterialRequisition;
import com.jeeplus.modules.warehouse.materialrequisition.entity.MaterialRequisitionInfo;
import com.jeeplus.modules.warehouse.outbound.entity.Outbound;
import com.jeeplus.modules.warehouse.outbound.entity.OutboundInfo;
import com.jeeplus.modules.warehouse.outbound.service.OutboundService;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.qrcode.service.QrCodeService;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;
import com.jeeplus.modules.warehouse.shelves.utils.ShelvesUtil;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.materialloss.entity.MaterialLoss;
import com.jeeplus.modules.warehouse.materialloss.mapper.MaterialLossMapper;
import com.jeeplus.modules.warehouse.materialloss.entity.MaterialLossInfo;
import com.jeeplus.modules.warehouse.materialloss.mapper.MaterialLossInfoMapper;

/**
 * 物资盘亏记录Service
 * @author zhanglt
 * @version 2023-02-14
 */
@Service
@Transactional(readOnly = true)
public class MaterialLossService extends CrudService<MaterialLossMapper, MaterialLoss> {

	@Autowired
	private MaterialLossInfoMapper materialLossInfoMapper;
	@Autowired
	private OutboundService outboundService;
	@Autowired
	private LedgerService ledgerService;
	@Autowired
	private LedgerInfoMapper ledgerInfoMapper;
	@Autowired
	private QrCodeService qrCodeService;

	public MaterialLoss get(String id) {
		MaterialLoss materialLoss = super.get(id);

		List<MaterialLossInfo> list = materialLossInfoMapper.findList(new MaterialLossInfo(materialLoss));
		for (MaterialLossInfo mri : list) {
			LedgerInfo li = mri.getLedgerInfo();
			List<Shelves> shelvesList = ShelvesUtil.getShelvesListByIds(li.getShelvesIds());
			li.setShelvesList(shelvesList);
			List<Warehouse> warehouseList = ShelvesUtil.getWarehouseListByIds(li.getWarehouseIds());
			li.setWarehouseList(warehouseList);
		}
		materialLoss.setMaterialLossInfoList(materialLossInfoMapper.findList(new MaterialLossInfo(materialLoss)));
		return materialLoss;
	}
	
	public List<MaterialLoss> findList(MaterialLoss materialLoss) {
		return super.findList(materialLoss);
	}
	
	public Page<MaterialLoss> findPage(Page<MaterialLoss> page, MaterialLoss materialLoss) {
		return super.findPage(page, materialLoss);
	}
	
	@Transactional(readOnly = false)
	public void save(MaterialLoss materialLoss) {
		super.save(materialLoss);
		//保存出库主表信息
		Outbound outbound = new Outbound();
		//设置相关表单id为物资盘亏主表的ID
		outbound.setRelationId(materialLoss.getId());
		List<Outbound> list = outboundService.findList(outbound);
		if(list != null && list.size()>0){
			outbound.setId(list.get(0).getId());
			outboundService.deleteInfo(outbound);
		}
		//设置当 前的操作人 与 发放物资的操作人相同
		outbound.setOperator(materialLoss.getOperator());
		//当前出库时间
		outbound.setOutboundTime(materialLoss.getTime());
		//出库类型为 领用出库
		outbound.setType("2");
		List<OutboundInfo> outboundInfoList = new ArrayList<>();
		for (MaterialLossInfo materialLossInfo : materialLoss.getMaterialLossInfoList()){
			if (materialLossInfo.getId() == null){
				continue;
			}
			if (MaterialLossInfo.DEL_FLAG_NORMAL.equals(materialLossInfo.getDelFlag())){
				OutboundInfo outboundInfo = new OutboundInfo();
				outboundInfo.setId("");
				outboundInfo.setOutbound(outbound);
				outboundInfo.setLedgerInfo(materialLossInfo.getLedgerInfo());
				outboundInfoList.add(outboundInfo);
				outbound.setOutboundInfoList(outboundInfoList);
				outboundService.saveOutbound(outbound);
				if (StringUtils.isBlank(materialLossInfo.getId())){
					materialLossInfo.setMaterialLoss(materialLoss);
					materialLossInfo.preInsert();
					materialLossInfoMapper.insert(materialLossInfo);
					String ledgerInfoId = materialLossInfo.getLedgerInfo().getId();
					LedgerInfo ledgerInfo = ledgerInfoMapper.get(ledgerInfoId);
					// ledgerInfoMapper.deleteByLedgerInfo(ledgerInfoId);
					ledgerInfo.setNum(ledgerInfo.getNum() - 1);
					ledgerInfoMapper.updateNum(ledgerInfo);
					if(ledgerInfo.getQr() != null){
						QrCode qrCode = qrCodeService.get(ledgerInfo.getQr().getId());
						if(qrCode!=null){
							qrCode.setState("3");
							qrCodeService.save(qrCode);
						}
					}
					if(ledgerInfo != null ){
						Ledger ledger = ledgerService.get(ledgerInfo.getLedger().getId());
						if(ledger != null){
							ledger.setNum(ledger.getNum() - 1);
							try {
								ledger.setSum(ledger.getSum().subtract(ledgerInfo.getAmount()));
							}catch (Exception e){
								System.out.println(e.getMessage());
							}
							ledgerService.lowerLedger(ledger);
						}
					}
				}else{
					materialLossInfo.setMaterialLoss(materialLoss);
					materialLossInfo.preUpdate();
					materialLossInfoMapper.update(materialLossInfo);
				}

			}else{
				materialLossInfoMapper.delete(materialLossInfo);
				String ledgerInfoId = materialLossInfo.getLedgerInfo().getId();
				LedgerInfo ledgerInfo = ledgerInfoMapper.get(ledgerInfoId);
				// ledgerInfoMapper.updateByLedgerInfo(ledgerInfoId);
				ledgerInfo.setNum(ledgerInfo.getNum() + 1);
				ledgerInfoMapper.updateNum(ledgerInfo);
				if(ledgerInfo.getQr() != null){
					QrCode qrCode = qrCodeService.get(ledgerInfo.getQr().getId());
					if(qrCode!=null){
						qrCode.setState("2");
						qrCodeService.save(qrCode);
					}
				}
				if(ledgerInfo != null ){
					Ledger ledger = ledgerService.get(ledgerInfo.getLedger().getId());
					if(ledger != null){
						ledger.setNum(ledger.getNum() + 1);
						try {
							ledger.setSum(ledger.getSum().add(ledgerInfo.getAmount()));
						}catch (Exception e){
							System.out.println(e.getMessage());
						}
						ledgerService.lowerLedger(ledger);
					}
				}
			}
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(MaterialLoss materialLoss) {
		super.delete(materialLoss);
		materialLossInfoMapper.delete(new MaterialLossInfo(materialLoss));
	}
	@Transactional(readOnly = false)
	public String createPKDH() {
		String pkdh = CodeUtil.code("PKDH", StaticNumSeq.PKDH);
		return pkdh;
	}
	//物资盘亏后生成 对应的 出库记录
	@Transactional(readOnly = false)
	public void delivery(MaterialLoss materialLoss) {
		if(materialLoss.getNumber() == null || Objects.equals(materialLoss.getNumber(), "")){
			materialLoss.setNumber(this.createPKDH());
		}
		this.save(materialLoss);
		Outbound outbound = new Outbound();
		//设置相关表单id为物资盘亏主表的ID
		outbound.setRelationId(materialLoss.getId());
		//查询当前记录是否已经出库
		List<Outbound> list = outboundService.findList(outbound);
		if(list != null && list.size()>0){
			return;
		}
		//设置当 前的操作人 与 发放物资的操作人相同
		outbound.setOperator(materialLoss.getOperator());
		//当前出库时间
		outbound.setOutboundTime(new Date());
		//出库类型为 领用出库
		outbound.setType("2");
		List<OutboundInfo> outboundInfoList = new ArrayList<>();
		List<MaterialLossInfo> materialLossInfoList = materialLoss.getMaterialLossInfoList();
		for (MaterialLossInfo one:materialLossInfoList) {
			OutboundInfo outboundInfo = new OutboundInfo();
			String ledgerInfoId = one.getLedgerInfo().getId();
			LedgerInfo ledgerInfo = ledgerInfoMapper.get(ledgerInfoId);
			if(ledgerInfo.getQr() != null){
				QrCode qrCode = qrCodeService.get(ledgerInfo.getQr().getId());
				if(qrCode!=null){
					qrCode.setState("3");
					qrCodeService.save(qrCode);
				}
			}
			if(ledgerInfo != null ){
				Ledger ledger = ledgerService.get(ledgerInfo.getLedger().getId());
				if(ledger != null){
					ledger.setNum(ledger.getNum() - 1);
					try {
						ledger.setSum(ledger.getSum().subtract(ledgerInfo.getAmount()));
					}catch (Exception e){
						System.out.println(e.getMessage());
					}
					ledgerService.lowerLedger(ledger);
				}
				ledgerInfo.setNum(ledgerInfo.getNum() - 1);
				ledgerInfoMapper.updateNum(ledgerInfo);
			}
			outboundInfo.setId("");
			outboundInfo.setOutbound(outbound);
			outboundInfo.setLedgerInfo(one.getLedgerInfo());
			outboundInfoList.add(outboundInfo);
		}
		outbound.setOutboundInfoList(outboundInfoList);
		outboundService.save(outbound);
	}
}