/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialloss.entity;


import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;

import java.util.Date;

/**
 * 盘亏明细表Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class MaterialLossInfo extends DataEntity<MaterialLossInfo> {
	
	private static final long serialVersionUID = 1L;
	private MaterialLoss materialLoss;		// 盘亏表主表ID
	private LedgerInfo ledgerInfo;		// 物资台账明细ID
	private String remarks;		// 物资台账明细ID
	/**
	 * 查询使用的属性-------
	 */
	private Date beginTime;
	private Date endTime;
	public MaterialLossInfo() {
		super();
	}

	@Override
	public String getRemarks() {
		return remarks;
	}

	@Override
	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public MaterialLossInfo(String id){
		super(id);
	}

	public MaterialLossInfo(MaterialLoss materialLoss) {
		this.materialLoss = materialLoss;
	}

	public MaterialLossInfo(String id, LedgerInfo ledgerInfo) {
		super(id);
		this.ledgerInfo = ledgerInfo;
	}

	public MaterialLossInfo(LedgerInfo ledgerInfo) {
		this.ledgerInfo = ledgerInfo;
	}

	@ExcelField(title="盘亏表主表ID", align=2, sort=1)
	public MaterialLoss getMaterialLoss() {
		return materialLoss;
	}

	public void setMaterialLoss(MaterialLoss materialLoss) {
		this.materialLoss = materialLoss;
	}
	
	@ExcelField(title="物资台账明细ID", align=2, sort=2)
	public LedgerInfo getLedgerInfo() {
		return ledgerInfo;
	}

	public void setLedgerInfo(LedgerInfo ledgerInfo) {
		this.ledgerInfo = ledgerInfo;
	}
	
}