<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<html>
<head>
    <title>入库信息管理</title>
    <meta name="decorator" content="ani"/>
    <link rel="stylesheet" href="${ctxStatic}/common/css/form.css">
    <link rel="stylesheet" href="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.css">
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table.min.js"></script>
    <script type="text/javascript" src="${ctxStatic}/plugin/bootstrapTable/bootstrap-table-zh-CN.js"></script>
</head>
<body>
<div class="wrapper wrapper-content">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-body">
                    <form:form id="inputForm" modelAttribute="storage" action="${ctx}/warehouse/storage/storage/save"
                               method="post" class="form-horizontal">
                        <h3 class="text-center">入库单</h3>
                        <form:hidden path="id"/>
                        <table class="table table-bordered main-table">
                            <tr>
                                <td> <font color="red">*</font>入库单</td>
                                <td>
                                    <form:input path="code" htmlEscape="false" readonly="true" class="form-control required"/>
                                </td>
                                <td><font color="red">*</font>操作人</td>
                                <td>
                                    <sys:userselect id="operator" name="operator.id" value="${storage.operator.id}"
                                                    labelName="operator.name" labelValue="${storage.operator.name}"
                                                    cssClass="form-control required" disabled="disabled"/>
                                </td>
                            </tr>
                            <tr>
                                <td><font color="red">*</font>时间</td>
                                <td>
                                    <div class='input-group form_datetime' id='time'>
                                        <input type='text' name="time" class="form-control required"
                                               value="<fmt:formatDate value="${storage.time}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
                                        <span class="input-group-addon">
								<span class="glyphicon glyphicon-calendar"></span>
							</span>
                                    </div>
                                </td>
                                <td>
                                    <font color="red">*</font>批次号
                                </td>
                                <td>
                                    <form:hidden path="batchNum" />
                                    <sys:gridselect url="${ctx}/warehouse/goods/goods/data" id="goods" name="goods.id" value="${storage.batchNum}" labelName="goods.name" labelValue="${storage.batchNum}"
                                                    title="选择货品批次" cssClass="form-control required" fieldLabels="批次号" fieldKeys="batchNum" searchLabels="批次号" searchKeys="batchNum" callback="onSelectGoods"></sys:gridselect>
                                </td>
                            </tr>
                            <tr>
                                <td>备注</td>
                                <td colspan="3">
                                    <form:textarea path="remarks" htmlEscape="false" rows="4" class="form-control "/>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <%@include file="storageDetail.jsp" %>
                                </td>
                            </tr>
                        </table>
                    </form:form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">

    $(document).ready(function () {
        initTable();
        jp.ajaxForm("#inputForm", function (data) {
            if (data.success) {
                jp.success(data.msg);
                jp.go("${ctx}/warehouse/storage/storage");
            } else {
                jp.error(data.msg);
                $("#inputForm").find("button:submit").button("reset");
            }
        });

        $('#time').datetimepicker({
            format: "YYYY-MM-DD HH:mm:ss"
        });
    });
    function save() {
        var isValidate = jp.validateForm('#inputForm');//校验表单
        if(!isValidate){
            return false;
        }else{
            jp.loading();
            jp.post($("#inputForm").attr('action'),$('#inputForm').serialize(),function(data){
                if(data.success){
                    jp.getParent().refresh();
                    var dialogIndex = parent.layer.getFrameIndex(window.name); // 获取窗口索引
                    parent.layer.close(dialogIndex);
                    jp.success(data.msg)

                }else{
                    jp.error(data.msg);
                }
            })
        }

    }

    function onSelectGoods(items){
        if(Array.isArray(items)&&items.length>0){
            var item = items[0];
            $("#batchNum").val(item.batchNum);
            $("#goodsId").val(item.id);
            $("#goodsName").val(item.batchNum);
        }
    }
</script>
</body>
</html>