<%--
  Created by IntelliJ IDEA.
  User: yangzi
  Date: 2023/2/21
  Time: 10:29
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/webpage/include/taglib.jsp" %>
<div id="toolbar" class="text-left">
  <a class="btn btn-primary btn-sm" onclick="addDetail('#detail_table')" title="新增"><i class="fa fa-plus"></i> 手动添加</a>
  <a class="btn btn-primary btn-sm" onclick="addScan('#detail_table')" title="新增"><i class="fa fa-plus"></i> 扫码添加</a>
  <a id="editAll" class="btn btn-primary btn-sm"  onclick="addShelve('#detail_table')" title="新增"><i class="fa fa-plus"></i> 批量编辑货架</a>
</div>
<table id="detail_table" data-toolbar="#toolbar"></table>
<script>
  var selector = "#detail_table";
  function initTable(){
    var data = ${fns:toJson(storage.storageInfoList)};
    $(selector).bootstrapTable({
      data: data,
      columns:[{checkbox: true},
        {
          field: 'no',
          title: '序号',
          align: 'center',
          width: 60,
          formatter: function (value, row, index){
            var tpl = $("#hideTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, "");
            var html = Mustache.render(tpl, {
              idx: index,
              row: row
            })

            return html + '<span>'+(index+1)+'</span>'
          }
        },
        {
          field: 'name',
          title: '名称',
          formatter: function (value,row,index){
            return Mustache.render($("#nameTpl").html(),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'type.name',
          title: '类型',
          formatter: function (value,row,index){
            return Mustache.render($("#typeTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'model',
          title: '型号',
          formatter: function (value,row,index){
            return Mustache.render($("#modelTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'num',
          title: '货架',
          formatter: function (value,row,index){
            return Mustache.render($("#shelvesTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: 'remarks',
          title: '备注',
          formatter: function (value,row,index){
            return Mustache.render($("#remarksTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g, ""),{
              row: row,
              idx: index
            })
          }
        },
        {
          field: '',
          title: '操作',
          formatter: function (value,row,index){
            var text = row.delFlag == 1 ? '撤销删除' : '删除';
            var result = ["<a href='javascript:void(0);' onclick=\"removeRow(" + index + ", '" + row.id + "',  '" + row.delFlag + "')\">"+text+"</a>" ]
            return result.join('');
          }
        }
      ]
    });
    $(selector).on('check.bs.table uncheck.bs.table load-success.bs.table ' +
            'check-all.bs.table uncheck-all.bs.table', function () {
      $('#editAll').prop('disabled', !getSelections().length);
    });
  }

  function getSelections(){
    return $(selector).bootstrapTable('getSelections');
  }

  function addDetail(selector){

    if(!$("#batchNum").val()){
      jp.warning('请选择批次号！');
      return;
    }

    jp.openStorageSelectDialog(true,$("#batchNum").val(),function (items){
        if(Array.isArray(items)){
          var data = items.map(function (item){
            if(item.goodsInfo && !item.goodsInfo.amount){
              item.goodsInfo.amount = 0;
            }
            return {
              id: '',
              delFlag: 0,
              remarks: '',
              ...item
            }
          })
          debugger
          $(selector).bootstrapTable('append', data)
        }
    })


  }
  function removeRow(index, rowId, rowDelFlag){
    if(rowId){
      var delFlag = rowDelFlag === 1 ? 0 : 1
      updateRow(index, {
        delFlag: delFlag
      })
    }else{
      $(selector).bootstrapTable("remove", {
        field: '$index',
        values: [index]
      })
    }
  }
  function updateRow(index, row){
    $(selector).bootstrapTable('updateRow', {
      index: index,
      row: row
    })
  }
  function onInputChange(rowIndex, elem , field){
    var obj = {};
    obj[field] = $(elem).val()
    var timer = null;
    clearTimeout(timer);
    timer = setTimeout(function (){
      updateRow(rowIndex, obj)
    }, 0)
  }

  function onSelectType(nodes, rowIndex){
    if(Array.isArray(nodes) && nodes.length === 1){
      var node = nodes[0];
      var obj = {
        type: {
          id: node.id,
          name: node.text
        }
      };
      updateRow(rowIndex, obj)
    }
  }

  function addShelve(){
    jp.openShelvesSelectDialog(function (id,name){

        getSelections().forEach(function (item,index){
          updateRow(index,{
            shelves: {
              id: id,
              name: name
            }
          })
        })

    })
  }

  function addScan(){
    layer.open({
      type: 1,
      title: '扫码',
      auto: true,
      area: ['500','300'],
      content: $("#scanResultTpl").html(),
      success: function (){
        $("#scanResult").focus();
      },
      btn:['关闭']
    })
  }

  /**
   * 扫码
   * 一、获取扫码结果
   * 二、请求后台接口获取结果
   * 三、增一条明细数据
   * 四、清空扫码结果
   * @param elem
   */
  function onScanChange(elem){
     try{
        var json = JSON.parse($(elem).val());
        var qrCodeId = json.code;
        var goodsInfoId = json.infoId;
     }catch (e){
       console.log(e);
     }
  }
</script>

<script id="hideTpl" type="text/html">
  <input id="storageInfoList{{idx}}_id" name="storageInfoList[{{idx}}].id" type="hidden" value="{{row.id}}"/>
  <input id="storageInfoList{{idx}}_delFlag" name="storageInfoList[{{idx}}].delFlag" type="hidden" value="{{row.delFlag}}"/>
  <input id="storageInfoList{{idx}}_goodsInfoId" name="storageInfoList[{{idx}}].goodsInfo.id" type="hidden" value="{{row.goodsInfo.id}}"/>
  <input id="storageInfoList{{idx}}_goodsInfoName" name="storageInfoList[{{idx}}].goodsInfo.name" type="hidden" value="{{row.goodsInfo.name}}"/>
  <input id="storageInfoList{{idx}}_goodsInfoAmount" name="storageInfoList[{{idx}}].goodsInfo.amount" type="hidden" value="{{row.goodsInfo.amount}}"/>
  <input id="storageInfoList{{idx}}_shelvesId" name="storageInfoList[{{idx}}].shelves.id" type="hidden" value="{{row.shelves.id}}" readonly class="form-control" />
  <input id="storageInfoList{{idx}}_amount" name="storageInfoList[{{idx}}].amount" type="hidden" value="{{row.amount}}" readonly class="form-control" />
  <input id="storageInfoList{{idx}}_qrCodeId" name="storageInfoList[{{idx}}].qrCode.id" type="hidden" value="{{row.qrCode.id}}" readonly class="form-control" />

</script>

<script id="nameTpl" type="text/html">
  <input id="storageInfoList{{idx}}_name" name="storageInfoList[{{idx}}].name" type="text" readonly value="{{row.name}}" onchange="onInputChange('{{idx}}', this, 'name')"   class="form-control "/>
</script>

<script id="typeTpl" type="text/html">//<!--
    <sys:treeselect id="storageInfoList{{idx}}_type" name="storageInfoList[{{idx}}].type.id" value="{{row.type.id}}" labelName="storageInfoList{{idx}}.type.name" labelValue="{{row.type.name}}"
							title="类型" url="/warehouse/materialtype/materialType/treeData" cssClass="form-control  " disabled="disabled" allowClear="true" allowSearch="true" callback="onSelectType" />//-->
</script>

<script id="modelTpl" type="text/html">
  <input id="storageInfoList{{idx}}_model" name="storageInfoList[{{idx}}].model" type="text" value="{{row.model}}" readonly onchange="onInputChange('{{idx}}', this, 'model')"    class="form-control "/>
</script>
<script id="shelvesTpl" type="text/html">
 <input id="storageInfoList{{idx}}_shelvesName" name="storageInfoList[{{idx}}].shelves.name" type="text" value="{{row.shelves.name}}"  readonly class="form-control" />
</script>
<script id="remarksTpl" type="text/html">
  <textarea id="storageInfoList{{idx}}_remarks" name="storageInfoList[{{idx}}].remarks" rows="4"  onchange="onInputChange('{{idx}}', this, 'remarks')"  class="form-control ">{{row.remarks}}</textarea>
</script>

<script id="scanResultTpl" type="text/html">
  <br>
  <div class="container-fluid">
    <div class="row">
      <div class="col-xs-2 text-right">
        <label>扫码结果:</label>
      </div>
      <div class="col-xs-10">
        <input type="text" id="scanResult" class="form-control" onchange="onScanChange(this)">
        <span class="text-danger">请切换英文输入法</span>
      </div>
    </div>
  </div>
  <br>
</script>