<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp"%>
<html>
<head>
	<title>盘盈入库单管理</title>
	<meta name="decorator" content="ani"/>
	<script type="text/javascript">

		$(document).ready(function() {
			jp.ajaxForm("#inputForm",function(data){
				if(data.success){
				    jp.success(data.msg);
					jp.go("${ctx}/warehouse/profitwarehousing/profitWarehousing");
				}else{
				    jp.error(data.msg);
				    $("#inputForm").find("button:submit").button("reset");
				}
			});
			
	        $('#time').datetimepicker({
				 format: "YYYY-MM-DD HH:mm:ss"
		    });
		});
		
		function addRow(list, idx, tpl, row){
			$(list).append(Mustache.render(tpl, {
				idx: idx, delBtn: true, row: row
			}));
			$(list+idx).find("select").each(function(){
				$(this).val($(this).attr("data-value"));
			});
			$(list+idx).find("input[type='checkbox'], input[type='radio']").each(function(){
				var ss = $(this).attr("data-value").split(',');
				for (var i=0; i<ss.length; i++){
					if($(this).val() == ss[i]){
						$(this).attr("checked","checked");
					}
				}
			});
			$(list+idx).find(".form_datetime").each(function(){
				 $(this).datetimepicker({
					 format: "YYYY-MM-DD HH:mm:ss"
			    });
			});
		}
		function delRow(obj, prefix){
			var id = $(prefix+"_id");
			var delFlag = $(prefix+"_delFlag");
			if (id.val() == ""){
				$(obj).parent().parent().remove();
			}else if(delFlag.val() == "0"){
				delFlag.val("1");
				$(obj).html("&divide;").attr("title", "撤销删除");
				$(obj).parent().parent().addClass("error");
			}else if(delFlag.val() == "1"){
				delFlag.val("0");
				$(obj).html("&times;").attr("title", "删除");
				$(obj).parent().parent().removeClass("error");
			}
		}
	</script>
</head>
<body>
<div class="wrapper wrapper-content">				
<div class="row">
	<div class="col-md-12">
	<div class="panel panel-primary">
		<div class="panel-heading">
			<h3 class="panel-title"> 
				<a class="panelButton" href="${ctx}/warehouse/profitwarehousing/profitWarehousing"><i class="ti-angle-left"></i> 返回</a>
			</h3>
		</div>
		<div class="panel-body">
		<form:form id="inputForm" modelAttribute="profitWarehousing" action="${ctx}/warehouse/profitwarehousing/profitWarehousing/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
				<div class="form-group">
					<label class="col-sm-2 control-label">盘盈入库单号：</label>
					<div class="col-sm-10">
						<form:input path="number" htmlEscape="false"    class="form-control "/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">操作人：</label>
					<div class="col-sm-10">
						<form:input path="operator" htmlEscape="false"    class="form-control "/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">时间：</label>
					<div class="col-sm-10">
						<div class='input-group form_datetime' id='time'>
							<input type='text'  name="time" class="form-control "  value="<fmt:formatDate value="${profitWarehousing.time}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
							<span class="input-group-addon">
								<span class="glyphicon glyphicon-calendar"></span>
							</span>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">备注信息：</label>
					<div class="col-sm-10">
						<form:textarea path="remarks" htmlEscape="false" rows="4"    class="form-control "/>
					</div>
				</div>
		<div class="tabs-container">
            <ul class="nav nav-tabs">
				<li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">盘盈入库单明细表：</a>
                </li>
            </ul>
            <div class="tab-content">
				<div id="tab-1" class="tab-pane fade in  active">
			<a class="btn btn-white btn-sm" onclick="addRow('#profitWarehousingInfoList', profitWarehousingInfoRowIdx, profitWarehousingInfoTpl);profitWarehousingInfoRowIdx = profitWarehousingInfoRowIdx + 1;" title="新增"><i class="fa fa-plus"></i> 新增</a>
			<table class="table table-striped table-bordered table-condensed">
				<thead>
					<tr>
						<th class="hide"></th>
						<th>盘盈入库主表ID</th>
						<th>名称</th>
						<th>类型</th>
						<th>型号</th>
						<th>货架ID</th>
						<th>备注信息</th>
						<th width="10">&nbsp;</th>
					</tr>
				</thead>
				<tbody id="profitWarehousingInfoList">
				</tbody>
			</table>
			<script type="text/template" id="profitWarehousingInfoTpl">//<!--
				<tr id="profitWarehousingInfoList{{idx}}">
					<td class="hide">
						<input id="profitWarehousingInfoList{{idx}}_id" name="profitWarehousingInfoList[{{idx}}].id" type="hidden" value="{{row.id}}"/>
						<input id="profitWarehousingInfoList{{idx}}_delFlag" name="profitWarehousingInfoList[{{idx}}].delFlag" type="hidden" value="0"/>
					</td>
					
					<td>
						<input id="profitWarehousingInfoList{{idx}}_profitWarehousing" name="profitWarehousingInfoList[{{idx}}].profitWarehousing.id" type="text" value="{{row.profitWarehousing.id}}"    class="form-control "/>
					</td>
					
					
					<td>
						<input id="profitWarehousingInfoList{{idx}}_name" name="profitWarehousingInfoList[{{idx}}].name" type="text" value="{{row.name}}"    class="form-control "/>
					</td>
					
					
					<td>
						<input id="profitWarehousingInfoList{{idx}}_type" name="profitWarehousingInfoList[{{idx}}].type" type="text" value="{{row.type}}"    class="form-control "/>
					</td>
					
					
					<td>
						<input id="profitWarehousingInfoList{{idx}}_marking" name="profitWarehousingInfoList[{{idx}}].marking" type="text" value="{{row.marking}}"    class="form-control "/>
					</td>
					
					
					<td>
						<input id="profitWarehousingInfoList{{idx}}_shelves" name="profitWarehousingInfoList[{{idx}}].shelves.id" type="text" value="{{row.shelves.id}}"    class="form-control "/>
					</td>
					
					
					<td>
						<textarea id="profitWarehousingInfoList{{idx}}_remarks" name="profitWarehousingInfoList[{{idx}}].remarks" rows="4"    class="form-control ">{{row.remarks}}</textarea>
					</td>
					
					<td class="text-center" width="10">
						{{#delBtn}}<span class="close" onclick="delRow(this, '#profitWarehousingInfoList{{idx}}')" title="删除">&times;</span>{{/delBtn}}
					</td>
				</tr>//-->
			</script>
			<script type="text/javascript">
				var profitWarehousingInfoRowIdx = 0, profitWarehousingInfoTpl = $("#profitWarehousingInfoTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g,"");
				$(document).ready(function() {
					var data = ${fns:toJson(profitWarehousing.profitWarehousingInfoList)};
					for (var i=0; i<data.length; i++){
						addRow('#profitWarehousingInfoList', profitWarehousingInfoRowIdx, profitWarehousingInfoTpl, data[i]);
						profitWarehousingInfoRowIdx = profitWarehousingInfoRowIdx + 1;
					}
				});
			</script>
			</div>
		</div>
		</div>
		<c:if test="${mode == 'add' || mode=='edit'}">
				<div class="col-lg-3"></div>
		        <div class="col-lg-6">
		             <div class="form-group text-center">
		                 <div>
		                     <button class="btn btn-primary btn-block btn-lg btn-parsley" data-loading-text="正在提交...">提 交</button>
		                 </div>
		             </div>
		        </div>
		</c:if>
		</form:form>
		</div>				
	</div>
	</div>
</div>
</div>
</body>
</html>