<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp"%>
<html>
<head>
	<title>物资盘亏记录管理</title>
	<meta name="decorator" content="ani"/>
	<script type="text/javascript">

		$(document).ready(function() {
			jp.ajaxForm("#inputForm",function(data){
				if(data.success){
				    jp.success(data.msg);
					jp.go("${ctx}/warehouse/materialloss/materialLoss");
				}else{
				    jp.error(data.msg);
				    $("#inputForm").find("button:submit").button("reset");
				}
			});
			
	        $('#time').datetimepicker({
				 format: "YYYY-MM-DD HH:mm:ss"
		    });
		});
		
		function addRow(list, idx, tpl, row){
			$(list).append(Mustache.render(tpl, {
				idx: idx, delBtn: true, row: row
			}));
			$(list+idx).find("select").each(function(){
				$(this).val($(this).attr("data-value"));
			});
			$(list+idx).find("input[type='checkbox'], input[type='radio']").each(function(){
				var ss = $(this).attr("data-value").split(',');
				for (var i=0; i<ss.length; i++){
					if($(this).val() == ss[i]){
						$(this).attr("checked","checked");
					}
				}
			});
			$(list+idx).find(".form_datetime").each(function(){
				 $(this).datetimepicker({
					 format: "YYYY-MM-DD HH:mm:ss"
			    });
			});
		}
		function delRow(obj, prefix){
			var id = $(prefix+"_id");
			var delFlag = $(prefix+"_delFlag");
			if (id.val() == ""){
				$(obj).parent().parent().remove();
			}else if(delFlag.val() == "0"){
				delFlag.val("1");
				$(obj).html("&divide;").attr("title", "撤销删除");
				$(obj).parent().parent().addClass("error");
			}else if(delFlag.val() == "1"){
				delFlag.val("0");
				$(obj).html("&times;").attr("title", "删除");
				$(obj).parent().parent().removeClass("error");
			}
		}
	</script>
</head>
<body>
<div class="wrapper wrapper-content">				
<div class="row">
	<div class="col-md-12">
	<div class="panel panel-primary">
		<div class="panel-heading">
			<h3 class="panel-title"> 
				<a class="panelButton" href="${ctx}/warehouse/materialloss/materialLoss"><i class="ti-angle-left"></i> 返回</a>
			</h3>
		</div>
		<div class="panel-body">
		<form:form id="inputForm" modelAttribute="materialLoss" action="${ctx}/warehouse/materialloss/materialLoss/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
				<div class="form-group">
					<label class="col-sm-2 control-label">盘亏单号：</label>
					<div class="col-sm-10">
						<form:input path="number" htmlEscape="false"    class="form-control "/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">操作人：</label>
					<div class="col-sm-10">
						<form:input path="operator" htmlEscape="false"    class="form-control "/>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">盘亏时间：</label>
					<div class="col-sm-10">
						<div class='input-group form_datetime' id='time'>
							<input type='text'  name="time" class="form-control "  value="<fmt:formatDate value="${materialLoss.time}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
							<span class="input-group-addon">
								<span class="glyphicon glyphicon-calendar"></span>
							</span>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-2 control-label">备注信息：</label>
					<div class="col-sm-10">
						<form:textarea path="remarks" htmlEscape="false" rows="4"    class="form-control "/>
					</div>
				</div>
		<div class="tabs-container">
            <ul class="nav nav-tabs">
				<li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">盘亏明细表：</a>
                </li>
            </ul>
            <div class="tab-content">
				<div id="tab-1" class="tab-pane fade in  active">
			<a class="btn btn-white btn-sm" onclick="addRow('#materialLossInfoList', materialLossInfoRowIdx, materialLossInfoTpl);materialLossInfoRowIdx = materialLossInfoRowIdx + 1;" title="新增"><i class="fa fa-plus"></i> 新增</a>
			<table class="table table-striped table-bordered table-condensed">
				<thead>
					<tr>
						<th class="hide"></th>
						<th>盘亏表主表ID</th>
						<th>物资台账明细ID</th>
						<th>备注信息</th>
						<th width="10">&nbsp;</th>
					</tr>
				</thead>
				<tbody id="materialLossInfoList">
				</tbody>
			</table>
			<script type="text/template" id="materialLossInfoTpl">//<!--
				<tr id="materialLossInfoList{{idx}}">
					<td class="hide">
						<input id="materialLossInfoList{{idx}}_id" name="materialLossInfoList[{{idx}}].id" type="hidden" value="{{row.id}}"/>
						<input id="materialLossInfoList{{idx}}_delFlag" name="materialLossInfoList[{{idx}}].delFlag" type="hidden" value="0"/>
					</td>
					
					<td>
						<input id="materialLossInfoList{{idx}}_materialLoss" name="materialLossInfoList[{{idx}}].materialLoss.id" type="text" value="{{row.materialLoss.id}}"    class="form-control "/>
					</td>
					
					
					<td>
						<input id="materialLossInfoList{{idx}}_ledgerInfo" name="materialLossInfoList[{{idx}}].ledgerInfo.id" type="text" value="{{row.ledgerInfo.id}}"    class="form-control "/>
					</td>
					
					
					<td>
						<textarea id="materialLossInfoList{{idx}}_remarks" name="materialLossInfoList[{{idx}}].remarks" rows="4"    class="form-control ">{{row.remarks}}</textarea>
					</td>
					
					<td class="text-center" width="10">
						{{#delBtn}}<span class="close" onclick="delRow(this, '#materialLossInfoList{{idx}}')" title="删除">&times;</span>{{/delBtn}}
					</td>
				</tr>//-->
			</script>
			<script type="text/javascript">
				var materialLossInfoRowIdx = 0, materialLossInfoTpl = $("#materialLossInfoTpl").html().replace(/(\/\/\<!\-\-)|(\/\/\-\->)/g,"");
				$(document).ready(function() {
					var data = ${fns:toJson(materialLoss.materialLossInfoList)};
					for (var i=0; i<data.length; i++){
						addRow('#materialLossInfoList', materialLossInfoRowIdx, materialLossInfoTpl, data[i]);
						materialLossInfoRowIdx = materialLossInfoRowIdx + 1;
					}
				});
			</script>
			</div>
		</div>
		</div>
		<c:if test="${mode == 'add' || mode=='edit'}">
				<div class="col-lg-3"></div>
		        <div class="col-lg-6">
		             <div class="form-group text-center">
		                 <div>
		                     <button class="btn btn-primary btn-block btn-lg btn-parsley" data-loading-text="正在提交...">提 交</button>
		                 </div>
		             </div>
		        </div>
		</c:if>
		</form:form>
		</div>				
	</div>
	</div>
</div>
</div>
</body>
</html>