package com.jeeplus.modules.warehouse.storage.dto;

import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.modules.warehouse.goods.entity.GoodsInfo;
import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;
import com.jeeplus.modules.warehouse.storage.entity.Storage;
import com.jeeplus.modules.warehouse.storage.entity.StorageInfo;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;

import java.math.BigDecimal;
import java.util.List;

public class CountStorageInfo  extends DataEntity<StorageInfo> {
    private static final long serialVersionUID = 1L;
    private Storage storage;		// 主表id 父类
    private String name;		// 名称
    private MaterialType type;		// 类型
    private String model;		// 型号
    private GoodsInfo goodsInfo;		// 货品明细id
    private Shelves shelves;		// 货架id
    private Warehouse warehouse; // 仓库外键
    private BigDecimal sum; // 单价
    private int num; // 数量

    private String shelvesNames; // 多个货架信息，前端展示使用
    private String warehouseNames; // 多个仓库信息，前端展示使用

    public CountStorageInfo() {
        super();
    }

    public CountStorageInfo(Storage storage){
        this.storage = storage;
    }

    public Storage getStorage() {
        return storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MaterialType getType() {
        return type;
    }

    public void setType(MaterialType type) {
        this.type = type;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public GoodsInfo getGoodsInfo() {
        return goodsInfo;
    }

    public void setGoodsInfo(GoodsInfo goodsInfo) {
        this.goodsInfo = goodsInfo;
    }

    public Shelves getShelves() {
        return shelves;
    }

    public void setShelves(Shelves shelves) {
        this.shelves = shelves;
    }

    public Warehouse getWarehouse() {
        return warehouse;
    }

    public void setWarehouse(Warehouse warehouse) {
        this.warehouse = warehouse;
    }

    public BigDecimal getSum() {
        return sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getShelvesNames() {
        return shelvesNames;
    }

    public void setShelvesNames(String shelvesNames) {
        this.shelvesNames = shelvesNames;
    }

    public String getWarehouseNames() {
        return warehouseNames;
    }

    public void setWarehouseNames(String warehouseNames) {
        this.warehouseNames = warehouseNames;
    }
}
